/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.openecard.scio.osx.SunOSXPCSC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardIO {
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_TERMINAL_FACTORY = 2;
    private static final int STATE_TERMINALS = 3;
    private final Logger log = LoggerFactory.getLogger(SmartCardIO.class);
    final Map<CardTerminal, Card> terminalCard_ = new HashMap<CardTerminal, Card>();
    int state_ = 1;
    TerminalFactory terminalFactory_ = null;
    CardTerminals cardTerminals_;

    private void updateTerminalFactory() {
        TerminalFactory terminalFactory;
        try {
            String string = System.getProperty("os.name");
            terminalFactory = string.contains("OS X") ? TerminalFactory.getInstance("PC/SC", null, new SunOSXPCSC()) : TerminalFactory.getInstance("PC/SC", null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.info("Failed to get TerminalFactory of type 'PC/SC'.", noSuchAlgorithmException);
            terminalFactory = TerminalFactory.getDefault();
        }
        this.log.debug("TerminalFactory : {}.", (Object)terminalFactory);
        if ("PC/SC".equals(terminalFactory.getType())) {
            this.terminalFactory_ = terminalFactory;
        }
        if (this.state_ < 2) {
            this.state_ = 2;
        }
    }

    public boolean isPCSCSupported() {
        if (this.state_ < 2) {
            this.updateTerminalFactory();
        }
        return this.terminalFactory_ != null;
    }

    private void updateCardTerminals() {
        if (this.terminalFactory_ != null) {
            this.cardTerminals_ = this.terminalFactory_.terminals();
        }
        this.log.debug("CardTerminals : {}.", (Object)this.cardTerminals_);
        if (this.state_ < 3) {
            this.state_ = 3;
        }
    }

    public CardTerminals getCardTerminals() {
        if (this.state_ < 2) {
            this.updateTerminalFactory();
        }
        if (this.state_ < 3) {
            this.updateCardTerminals();
        }
        return this.cardTerminals_;
    }

    public boolean isTerminalPresent() {
        CardTerminals cardTerminals = this.getCardTerminals();
        if (cardTerminals != null) {
            List<CardTerminal> list = null;
            try {
                list = cardTerminals.list(CardTerminals.State.ALL);
                if (this.log.isInfoEnabled()) {
                    if (list == null || list.isEmpty()) {
                        this.log.info("No card terminal found.");
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Found " + list.size() + " card terminal(s):");
                        for (CardTerminal cardTerminal : list) {
                            stringBuffer.append("\n  " + cardTerminal.getName());
                        }
                        this.log.info(stringBuffer.toString());
                    }
                }
                return list != null && !list.isEmpty();
            }
            catch (CardException cardException) {
                this.log.info("Failed to list card terminals.", cardException);
                return false;
            }
        }
        return false;
    }

    private Map<CardTerminal, Card> updateCards() {
        try {
            this.log.trace("terminals.list(State.CARD_REMOVAL)");
            for (CardTerminal object : this.cardTerminals_.list(CardTerminals.State.CARD_REMOVAL)) {
                Card card = this.terminalCard_.remove(object);
                this.log.trace("card removed : {}", (Object)card);
            }
        }
        catch (CardException cardException) {
            this.log.debug("Failed to list terminals.", cardException);
        }
        HashMap hashMap = new HashMap();
        try {
            this.log.trace("terminals.list(State.CARD_INSERTION)");
            for (CardTerminal cardTerminal : this.cardTerminals_.list(CardTerminals.State.CARD_INSERTION)) {
                Card card = null;
                try {
                    this.log.trace("Trying to connect to card.");
                    card = cardTerminal.connect("*");
                }
                catch (CardException cardException) {
                    this.log.trace("Failed to connect to card.", cardException);
                }
                if (this.terminalCard_.put(cardTerminal, card) != null) continue;
                this.terminalCard_.put(cardTerminal, card);
                hashMap.put(cardTerminal, card);
                this.log.trace("terminal '{}' card inserted : {}", (Object)cardTerminal, (Object)card);
            }
        }
        catch (CardException cardException) {
            this.log.debug("Failed to list cards.", cardException);
        }
        return hashMap;
    }

    public Map<CardTerminal, Card> getCards() {
        if (this.state_ < 2) {
            this.updateTerminalFactory();
        }
        if (this.state_ < 3) {
            this.updateCardTerminals();
        }
        this.updateCards();
        HashMap<CardTerminal, Card> hashMap = new HashMap<CardTerminal, Card>();
        hashMap.putAll(this.terminalCard_);
        return Collections.unmodifiableMap(hashMap);
    }

    public Map<CardTerminal, Card> waitForInserted(int n) {
        if (this.state_ < 2) {
            this.updateTerminalFactory();
        }
        if (this.state_ < 3) {
            this.updateCardTerminals();
        }
        try {
            this.cardTerminals_.waitForChange(n);
        }
        catch (CardException cardException) {
            this.log.debug("CardTerminals.waitForChange({}) failed.", (Object)n, (Object)cardException);
        }
        HashMap<CardTerminal, Card> hashMap = new HashMap<CardTerminal, Card>();
        hashMap.putAll(this.updateCards());
        return Collections.unmodifiableMap(hashMap);
    }
}

