/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import at.gv.egiz.smcc.CardNotSupportedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardFactory;
import at.gv.egiz.smcc.util.LinuxLibraryFinder;
import at.gv.egiz.smcc.util.SmartCardIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMCCHelper {
    public static final int NO_CARD = 0;
    public static final int PC_SC_NOT_SUPPORTED = 1;
    public static final int TERMINAL_NOT_PRESENT = 2;
    public static final int CARD_NOT_SUPPORTED = 3;
    public static final int CARD_FOUND = 4;
    private final Logger log = LoggerFactory.getLogger(SMCCHelper.class);
    protected SmartCardIO smartCardIO = new SmartCardIO();
    protected int resultCode = 0;
    protected SignatureCard signatureCard = null;
    protected static boolean useSWCard = false;

    public SMCCHelper() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Linux")) {
            try {
                File file = LinuxLibraryFinder.getLibraryPath("pcsclite", "1");
                System.setProperty("sun.security.smartcardio.library", file.getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.error("PC/SC library not found", fileNotFoundException);
            }
        }
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        this.update();
    }

    public synchronized void update() {
        this.update(-1);
    }

    public synchronized void update(int n) {
        SignatureCardFactory signatureCardFactory = SignatureCardFactory.getInstance();
        if (useSWCard) {
            this.log.info("Using SW Card");
            try {
                this.signatureCard = signatureCardFactory.createSignatureCard(null, null);
                this.resultCode = 4;
            }
            catch (CardNotSupportedException cardNotSupportedException) {
                this.resultCode = 3;
                this.signatureCard = null;
            }
            return;
        }
        this.signatureCard = null;
        this.resultCode = 0;
        if (this.smartCardIO.isPCSCSupported()) {
            if (this.smartCardIO.isTerminalPresent()) {
                Map<CardTerminal, Card> map = null;
                if (n > 0) {
                    this.smartCardIO.waitForInserted(n);
                }
                map = this.smartCardIO.getCards();
                for (CardTerminal cardTerminal : map.keySet()) {
                    Object[] objectArray;
                    try {
                        Card card = map.get(cardTerminal);
                        if (card == null) {
                            throw new CardNotSupportedException();
                        }
                        this.signatureCard = signatureCardFactory.createSignatureCard(card, cardTerminal);
                        if (this.log.isTraceEnabled()) {
                            objectArray = new Object[]{this.signatureCard, cardTerminal.getName(), SMCCHelper.toString(map.get(cardTerminal).getATR().getBytes())};
                            this.log.trace("Found supported card ({}) in terminal '{}', ATR = {}.", objectArray);
                        }
                        this.resultCode = 4;
                        break;
                    }
                    catch (CardNotSupportedException cardNotSupportedException) {
                        objectArray = map.get(cardTerminal);
                        if (objectArray != null) {
                            Object[] objectArray2 = new Object[]{cardTerminal.getName(), SMCCHelper.toString(objectArray.getATR().getBytes())};
                            this.log.info("Found unsupported card in terminal '{}', ATR = {}.", objectArray2);
                        } else {
                            this.log.info("Found unsupported card in terminal '{}' without ATR.", (Object)cardTerminal.getName());
                        }
                        this.resultCode = 3;
                    }
                }
            } else {
                this.resultCode = 2;
            }
        } else {
            this.resultCode = 1;
        }
    }

    public synchronized SignatureCard getSignatureCard(Locale locale) {
        if (this.signatureCard != null) {
            this.signatureCard.setLocale(locale);
        }
        return this.signatureCard;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (byArray != null && byArray.length > 0) {
            stringBuffer.append(Integer.toHexString((byArray[0] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[0] & 0xF));
            for (int i = 1; i < byArray.length; ++i) {
                stringBuffer.append(i % 32 == 0 ? (char)'\n' : ':');
                stringBuffer.append(Integer.toHexString((byArray[i] & 0xF0) >> 4));
                stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static byte[] toByteArray(int n) throws CardException {
        String string = Integer.toHexString(n);
        if (string.length() > 4) {
            throw new CardException("Unexpected input length to toByteArray() utility method: " + string.length());
        }
        byte by = 0;
        byte by2 = 0;
        if (string.length() <= 2) {
            by2 = (byte)Integer.parseInt(string, 16);
        } else {
            by2 = (byte)Integer.parseInt(string.substring(string.length() - 2), 16);
            by = (byte)Integer.parseInt(string.substring(0, string.length() - 2), 16);
        }
        return new byte[]{by, by2};
    }

    public static BigInteger createUnsignedBigInteger(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 0;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return new BigInteger(byArray2);
    }

    public static boolean isUseSWCard() {
        return useSWCard;
    }

    public static void setUseSWCard(boolean bl) {
        useSWCard = bl;
    }
}

