/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import at.gv.egiz.smcc.util.MSCMConstants;
import at.gv.egiz.smcc.util.MSCMDecoder;
import at.gv.egiz.smcc.util.MSCMException;
import at.gv.egiz.smcc.util.MSCMTransfer;
import iaik.me.security.Cipher;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;

public class MSCMService
implements MSCMConstants {
    MSCMTransfer transfer;

    public MSCMService(CardChannel cardChannel) {
        this.transfer = new MSCMTransfer(cardChannel);
    }

    public String[] getFiles(String string) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)-6357, "MSCM", MSCMDecoder.encodeString(string));
        return MSCMDecoder.decodeStringArray(this.transfer.transfer(byArray, (short)4392), 0);
    }

    public byte[] getFileProperties(String string) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)-24549, "MSCM", MSCMDecoder.encodeString(string));
        return MSCMDecoder.decodeByteArray(this.transfer.transfer(byArray, (short)17827), 0);
    }

    public void verifyPin(byte by, byte[] byArray) throws IOException, CardException, MSCMException {
        byte[] byArray2 = this.buildAPDU((short)5, 12602190, (short)32701, (short)20587, "MSCM", MSCMDecoder.concatByteArrays(new byte[]{by}, MSCMDecoder.encodeByteArray(byArray)));
        this.transfer.transfer(byArray2, (short)-12671);
    }

    public void changePIN(byte by, byte[] byArray, byte[] byArray2, int n) throws IOException, CardException, MSCMException {
        byte[] byArray3 = MSCMDecoder.concatByteArrays(new byte[]{0, by}, MSCMDecoder.encodeByteArray(byArray));
        byte[] byArray4 = MSCMDecoder.concatByteArrays(byArray3, MSCMDecoder.encodeByteArray(byArray2));
        byte[] byArray5 = MSCMDecoder.concatByteArrays(byArray4, MSCMService.intToBytes(n));
        byte[] byArray6 = this.buildAPDU((short)5, 12602190, (short)32701, (short)-8054, "MSCM", byArray5);
        this.transfer.transfer(byArray6, (short)-12671);
    }

    public void unblockPIN(byte by, byte[] byArray, byte[] byArray2, int n) throws IOException, CardException, MSCMException {
        byte[] byArray3 = MSCMDecoder.concatByteArrays(new byte[]{1, by}, MSCMDecoder.encodeByteArray(byArray));
        byte[] byArray4 = MSCMDecoder.concatByteArrays(byArray3, MSCMDecoder.encodeByteArray(byArray2));
        byte[] byArray5 = MSCMDecoder.concatByteArrays(byArray4, MSCMService.intToBytes(n));
        byte[] byArray6 = this.buildAPDU((short)5, 12602190, (short)32701, (short)-8054, "MSCM", byArray5);
        this.transfer.transfer(byArray6, (short)-12671);
    }

    public int[] queryFreeSpace() throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)229, "MSCM", null);
        return MSCMDecoder.decodeIntArray(this.transfer.transfer(byArray, (short)25025), 0);
    }

    public void forceGC() throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)15672, "MSCM", null);
        this.transfer.transfer(byArray, (short)-12671);
    }

    public byte[] readFile(String string) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)29772, "MSCM", MSCMDecoder.concatByteArrays(MSCMDecoder.encodeString(string), MSCMService.intToBytes(0)));
        return MSCMDecoder.decodeByteArray(this.transfer.transfer(byArray, (short)17827), 0);
    }

    public byte[] privateKeyDecrypt(byte by, byte by2, byte[] byArray) throws IOException, CardException, MSCMException {
        byte[] byArray2 = this.buildAPDU((short)5, 12602190, (short)32701, (short)24900, "MSCM", MSCMDecoder.concatByteArrays(new byte[]{by, by2}, MSCMDecoder.encodeByteArray(byArray)));
        return MSCMDecoder.decodeByteArray(this.transfer.transfer(byArray2, (short)17827), 0);
    }

    public int getTriesRemaining(byte by) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)27912, "MSCM", new byte[]{by});
        return MSCMService.bytesToInt(this.transfer.transfer(byArray, (short)25024), 0);
    }

    public String getVersion() throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)-8468, "MSCM", null);
        return MSCMDecoder.decodeString(this.transfer.transfer(byArray, (short)4391), 0);
    }

    public byte[] getContainerProperty(byte by, byte by2, byte by3) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)10140, "MSCM", new byte[]{by, by2, by3});
        return this.transfer.transfer(byArray, (short)17827);
    }

    public byte[] getCardProperty(byte by, byte by2) throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)-32377, "MSCM", new byte[]{by, by2});
        return this.transfer.transfer(byArray, (short)17827);
    }

    public static String bytArrayToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02X ", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static String bytArrayToHex(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuilder.append(String.format("%02X ", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(s & 0xFF);
        byArray[0] = (byte)(s >> 8 & 0xFF);
        return byArray;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[0] = (byte)(n >> 24 & 0xFF);
        return byArray;
    }

    public static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4 && i + n < byArray.length; ++i) {
            n2 <<= 8;
            n2 |= byArray[n + i] & 0xFF;
        }
        return n2;
    }

    public static short bytesToShort(byte[] byArray, int n) {
        short s = 0;
        for (int i = 0; i < 2 && i + n < byArray.length; ++i) {
            s = (short)(s << 8);
            s = (short)(s | (short)byArray[i + n] & 0xFF);
        }
        return s;
    }

    public byte[] buildAPDU(short s, int n, short s2, short s3, String string, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = string.getBytes("UTF-8");
        byArray2[0] = -40;
        byArray3[0] = 111;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(MSCMService.shortToBytes(s));
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(MSCMService.intToBytes(n));
        byteArrayOutputStream.write(MSCMService.shortToBytes(s2));
        byteArrayOutputStream.write(MSCMService.shortToBytes(s3));
        byteArrayOutputStream.write(MSCMService.shortToBytes((short)byArray4.length));
        byteArrayOutputStream.write(byArray4);
        if (byArray != null) {
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] cryptoResponse(byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, CryptoBag.makeSecretKey(byArray2));
            byte[] byArray3 = cipher.doFinal(byArray);
            System.out.println("Crypto result: " + MSCMService.bytArrayToHex(byArray3));
            return byArray3;
        }
        catch (CryptoException cryptoException) {
            System.out.println("Failed to get crypto stuff" + cryptoException.getMessage());
            return null;
        }
    }

    public void doExternalAuthentication(byte[] byArray) throws IOException, CardException, MSCMException {
        byte[] byArray2 = this.buildAPDU((short)5, 12602190, (short)32701, (short)9470, "MSCM", MSCMDecoder.encodeByteArray(byArray));
        this.transfer.transfer(byArray2, (short)-12671);
    }

    public byte[] getChallenge() throws IOException, CardException, MSCMException {
        byte[] byArray = this.buildAPDU((short)5, 12602190, (short)32701, (short)-1477, "MSCM", null);
        return MSCMDecoder.decodeByteArray(this.transfer.transfer(byArray, (short)17827), 0);
    }
}

