/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxLibraryFinder {
    private static final Logger logger = LoggerFactory.getLogger(LinuxLibraryFinder.class);

    public static File getLibraryPath(String string, String string2) throws FileNotFoundException {
        string2 = string2 == null ? "" : string2;
        string2 = string2.isEmpty() ? "" : "." + string2;
        String string3 = System.mapLibraryName(string) + string2;
        File file = LinuxLibraryFinder.findInEnv(string3, System.getenv("LD_LIBRARY_PATH"));
        if (file != null) {
            return file;
        }
        file = LinuxLibraryFinder.findInLdCache(string3);
        if (file != null) {
            return file;
        }
        file = LinuxLibraryFinder.findInBaseLibPaths(string3);
        if (file != null) {
            return file;
        }
        throw new FileNotFoundException("Library " + string3 + " not found on your system.");
    }

    private static File findInEnv(String string, String string2) {
        if (string2 != null) {
            for (String string3 : string2.split(":")) {
                String string4 = string3 + "/" + string;
                File file = new File(string4.trim());
                if (!file.canRead()) continue;
                return file;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File findInLdCache(String string) {
        String string2 = LinuxLibraryFinder.findProgramFile("ldconfig") + " -p";
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string2);
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (true) {
                String string3;
                if ((string3 = bufferedReader.readLine()) != null) {
                    String string4;
                    File file;
                    if (!string3.endsWith(string)) continue;
                    int n = string3.lastIndexOf("=>");
                    if (n == -1 || !(file = new File((string4 = string3.substring(n + 2)).trim())).canRead()) continue;
                    File file2 = file;
                    return file2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            logger.debug("Library {} not found in ld.so.cache.", (Object)string);
        }
        finally {
            if (process != null) {
                try {
                    process.getInputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static String findProgramFile(String string) {
        String string2 = System.getenv().get("PATH");
        string2 = string2 == null ? "" : string2;
        string2 = "/sbin:/usr/sbin:" + string2;
        for (String string3 : string2.split(":")) {
            String string4 = string3 + "/" + string;
            File file = new File(string4);
            if (!file.canExecute()) continue;
            return string4;
        }
        return string;
    }

    private static File findInBaseLibPaths(String string) {
        String[] stringArray;
        String string2 = "64".equals(System.getProperty("sun.arch.data.model")) ? "64" : "";
        for (String string3 : stringArray = new String[]{"/lib" + string2, "/usr/lib" + string2}) {
            String string4 = string3 + "/" + string;
            File file = new File(string4);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }
}

