/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.reader;

import at.gv.egiz.smcc.conf.SMCCConfiguration;
import at.gv.egiz.smcc.reader.CardReader;
import at.gv.egiz.smcc.reader.DefaultCardReader;
import at.gv.egiz.smcc.reader.PinpadCardReader;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderFactory {
    private final Logger log = LoggerFactory.getLogger(ReaderFactory.class);
    protected static SMCCConfiguration configuration;
    static int IOCTL_GET_FEATURE_REQUEST;

    public void setConfiguration(SMCCConfiguration sMCCConfiguration) {
        if (sMCCConfiguration != null) {
            this.log.info("reader configuration: disablePinpad=" + sMCCConfiguration.isDisablePinpad());
        }
        configuration = sMCCConfiguration;
    }

    public static CardReader getReader(Card card, CardTerminal cardTerminal) {
        Logger logger = LoggerFactory.getLogger(ReaderFactory.class);
        String string = cardTerminal.getName();
        logger.info("Creating reader : {}.", (Object)string);
        Map<Byte, Integer> map = configuration != null && configuration.isDisablePinpad() ? Collections.emptyMap() : ReaderFactory.queryFeatures(card);
        DefaultCardReader defaultCardReader = map.isEmpty() ? new DefaultCardReader(cardTerminal) : new PinpadCardReader(cardTerminal, map);
        return defaultCardReader;
    }

    private static int SCARD_CTL_CODE(int n) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") > -1) {
            return 0x310000 | n << 2;
        }
        return 0x42000000 + n;
    }

    private static Map<Byte, Integer> queryFeatures(Card card) {
        Logger logger = LoggerFactory.getLogger(ReaderFactory.class);
        HashMap<Byte, Integer> hashMap = new HashMap<Byte, Integer>();
        if (card == null) {
            logger.warn("Invalid card handle, cannot query ifd features.");
        } else {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("GET_FEATURE_REQUEST {}", (Object)Integer.toHexString(IOCTL_GET_FEATURE_REQUEST));
                }
                byte[] byArray = card.transmitControlCommand(IOCTL_GET_FEATURE_REQUEST, new byte[0]);
                if (logger.isTraceEnabled()) {
                    logger.trace("Response TLV {}", (Object)SMCCHelper.toString(byArray));
                }
                for (int i = 0; i < byArray.length; i += 6) {
                    Byte by = new Byte(byArray[i]);
                    Integer n = new Integer((0xFF & byArray[i + 2]) << 24) | (0xFF & byArray[i + 3]) << 16 | (0xFF & byArray[i + 4]) << 8 | 0xFF & byArray[i + 5];
                    if (logger.isInfoEnabled()) {
                        if (by.intValue() < CardReader.FEATURES.length) {
                            logger.info("IFD supports {}: {}", (Object)CardReader.FEATURES[by.intValue()], (Object)Integer.toHexString(n));
                        } else {
                            logger.info("IFD supports unknown feature 0x{}, : {}", (Object)Integer.toHexString(by.byteValue()), (Object)Integer.toHexString(n));
                        }
                    }
                    hashMap.put(by, n);
                }
            }
            catch (CardException cardException) {
                logger.debug("Failed to query IFD features: {}", (Object)cardException.getMessage(), (Object)cardException);
                logger.info("IFD does not support secure pin entry.");
            }
        }
        return hashMap;
    }

    static {
        IOCTL_GET_FEATURE_REQUEST = ReaderFactory.SCARD_CTL_CODE(3400);
    }
}

