/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.cio;

import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.cio.CIOCertificateDirectory;
import at.gv.egiz.smcc.cio.LIEZertifikatCertificateDirectory;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TLV;
import at.gv.egiz.smcc.util.TLVSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDirectory {
    protected static final Logger log = LoggerFactory.getLogger(ObjectDirectory.class);
    protected byte[] fid;
    protected CIOCertificateDirectory efCD;
    protected CIOCertificateDirectory efPrKD;
    private List<byte[]> PrKD_refs;
    private List<byte[]> PuKD_refs;
    private List<byte[]> AOD_refs;
    private List<byte[]> CD_refs;
    private Integer padding;
    private int P1 = 2;

    public ObjectDirectory() {
        this.fid = new byte[]{80, 49};
    }

    public ObjectDirectory(byte[] byArray) {
        this.fid = byArray;
    }

    public ObjectDirectory(int n, int n2) {
        this.fid = new byte[]{80, 49};
        this.padding = n;
        this.P1 = n2;
    }

    public void selectAndRead(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, this.P1, 0, this.fid, 256);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("SELECT EF.OD failed: SW=0x" + Integer.toHexString(responseAPDU.getSW()));
        }
        byte[] byArray = ISO7816Utils.readTransparentFile(cardChannel, -1);
        this.PrKD_refs = new ArrayList<byte[]>();
        this.PuKD_refs = new ArrayList<byte[]>();
        this.AOD_refs = new ArrayList<byte[]>();
        this.CD_refs = new ArrayList<byte[]>();
        for (TLV tLV : new TLVSequence(byArray)) {
            int n = tLV.getTag();
            if (this.padding != null && n == this.padding) break;
            byte[] byArray2 = tLV.getValue();
            if ((n & 0xF0) == 160 && byArray2.length >= 4) {
                byte[] byArray3 = Arrays.copyOfRange(byArray2, 4, 4 + byArray2[3]);
                switch (tLV.getTag() & 0xF) {
                    case 0: {
                        this.PrKD_refs.add(byArray3);
                        break;
                    }
                    case 1: {
                        this.PuKD_refs.add(byArray3);
                        break;
                    }
                    case 4: {
                        this.CD_refs.add(byArray3);
                        break;
                    }
                    case 8: {
                        this.AOD_refs.add(byArray3);
                        break;
                    }
                    default: {
                        log.warn("CIOChoice 0x{} not supported: ", (Object)(tLV.getTag() & 0xF));
                        break;
                    }
                }
                continue;
            }
            log.trace("ignoring invalid CIO reference entry: {}", (Object)byArray2);
        }
    }

    public CIOCertificateDirectory getCD(CardChannel cardChannel) throws CardException, SignatureCardException {
        if (this.efCD == null) {
            if (this.CD_refs == null) {
                this.selectAndRead(cardChannel);
            }
            this.efCD = new LIEZertifikatCertificateDirectory(this.CD_refs);
        }
        return this.efCD;
    }

    public CIOCertificateDirectory getPrKD(CardChannel cardChannel) throws CardException, SignatureCardException {
        if (this.efPrKD == null) {
            if (this.PrKD_refs == null) {
                this.selectAndRead(cardChannel);
            }
            this.efPrKD = new LIEZertifikatCertificateDirectory(this.PrKD_refs);
        }
        return this.efPrKD;
    }

    public List<byte[]> getPrKDReferences() {
        return this.PrKD_refs;
    }

    public List<byte[]> getPuKDReferences() {
        return this.PuKD_refs;
    }

    public List<byte[]> getAODReferences() {
        return this.AOD_refs;
    }

    public List<byte[]> getCDReferences() {
        return this.CD_refs;
    }

    public int getP1() {
        return this.P1;
    }

    public void setP1(int n) {
        this.P1 = n;
    }
}

