/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.cio;

import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.cio.CIO;
import at.gv.egiz.smcc.util.ISO7816Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CIODirectoryFile {
    protected static final Logger log = LoggerFactory.getLogger(CIODirectoryFile.class);
    protected List<byte[]> DF_FIDs;

    public CIODirectoryFile(List<byte[]> list) {
        this.DF_FIDs = list;
    }

    public void readCIOs(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        for (byte[] byArray : this.DF_FIDs) {
            byte[] byArray2 = this.selectDirectoryFile(cardChannel, byArray);
            if ((byArray2[0] & 4) > 0) {
                this.readCIOsFromRecords(cardChannel, byArray2);
                continue;
            }
            if ((byArray2[0] & 5) != 1) continue;
            this.readCIOsFromTransparentFile(cardChannel);
        }
    }

    protected abstract byte[] selectDirectoryFile(CardChannel var1, byte[] var2) throws CardException;

    protected void readCIOsFromRecords(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException, IOException {
        for (int i = 1; i < byArray[byArray.length - 1]; ++i) {
            log.trace("read CIO record {}", (Object)i);
            byte[] byArray2 = ISO7816Utils.readRecord(cardChannel, i);
            this.addCIO(byArray2);
        }
    }

    protected void readCIOsFromTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        int n;
        byte[] byArray = ISO7816Utils.readTransparentFile(cardChannel, -1);
        int n2 = 0;
        do {
            int n3 = 0;
            int n4 = 0;
            if ((byArray[n2 + 1] & 0xF0) == 128) {
                n4 = byArray[n2 + 1] & 0x7F;
                for (int i = 0; i < n4; ++i) {
                    n3 = (n3 << 8) + (byArray[n2 + i + 2] & 0xFF);
                }
            } else {
                n3 = byArray[n2 + 1] & 0xFF;
            }
            log.trace("read CIO transparent file entry: tag 0x{}, length 0x{}", (Object)Integer.toHexString(byArray[n2]), (Object)Integer.toHexString(n3));
            n = n2 + 2 + n4 + n3;
            this.addCIO(Arrays.copyOfRange(byArray, n2, n));
        } while ((n2 = n) < byArray.length && byArray[n2] > 0);
    }

    protected abstract void addCIO(byte[] var1) throws IOException;

    public abstract List<? extends CIO> getCIOs(CardChannel var1) throws CardException, SignatureCardException, IOException;
}

