/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.cio;

import at.gv.egiz.smcc.cio.CIO;
import iaik.me.asn1.ASN1;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIOCertificate
extends CIO {
    protected static final Logger log = LoggerFactory.getLogger(CIOCertificate.class);
    private byte[] iD;
    private byte[] efidOrPath;
    private int serialNumber;

    public CIOCertificate(byte[] byArray) throws IOException {
        ASN1 aSN1 = new ASN1(byArray);
        ASN1 aSN12 = aSN1.getElementAt(0);
        this.label = aSN12.getElementAt(0).gvString();
        try {
            this.authId = aSN12.getElementAt(2).gvByteArray();
        }
        catch (IOException iOException) {
            log.info("failed to get authId from CommonObjectAttributes: {}", (Object)iOException.getMessage());
        }
        this.iD = aSN1.getElementAt(1).getElementAt(0).gvByteArray();
        byte[] byArray2 = aSN1.getElementAt(aSN1.getSize() - 1).getEncoded();
        if ((byArray2[0] & 0xFF) == 161) {
            int n = (byArray2[1] & 0xF0) == 128 ? (byArray2[1] & 0xF) + 2 : 2;
            ASN1 aSN13 = new ASN1(Arrays.copyOfRange(byArray2, n, byArray2.length));
            this.efidOrPath = aSN13.getElementAt(0).getElementAt(0).gvByteArray();
        } else {
            log.warn("expected CONTEXTSPECIFIC, got 0x{}", (Object)Integer.toHexString(byArray2[0]));
        }
    }

    public byte[] getiD() {
        return this.iD;
    }

    public void setiD(byte[] byArray) {
        this.iD = byArray;
    }

    public byte[] getEfidOrPath() {
        return this.efidOrPath;
    }

    public void setEfidOrPath(byte[] byArray) {
        this.efidOrPath = byArray;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }
}

