/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.ChangeReferenceDataAPDUSpec;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.Infobox;
import at.gv.egiz.smcc.InfoboxContainer;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NewReferenceDataAPDUSpec;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PINMgmtSignatureCard;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.ResetRetryCounterAPDUSpec;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.SignatureCardFactory;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import at.gv.egiz.smcc.util.TransparentFileInputStream;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STARCOSCard
extends AbstractSignatureCard
implements PINMgmtSignatureCard {
    private final Logger log = LoggerFactory.getLogger(STARCOSCard.class);
    public static final byte[] MF = new byte[]{63, 0};
    public static final byte[] EF_VERSION = new byte[]{0, 50};
    public static final byte[] AID_SV_PERSONENDATEN = new byte[]{-48, 64, 0, 0, 23, 1, 1, 1};
    public static final byte[] FID_GRUNDDATEN = new byte[]{-17, 1};
    public static final byte[] FID_EHIC = new byte[]{-17, 2};
    public static final byte[] FID_SV_PERSONENBINDUNG = new byte[]{-17, 3};
    public static final byte[] FID_STATUS = new byte[]{-17, 4};
    public static final byte[] AID_INFOBOX = new byte[]{-48, 64, 0, 0, 23, 0, 24, 1};
    public static final byte[] AID_INFOBOXG4 = new byte[]{-48, 64, 0, 0, 34, 0, 3};
    public static final byte[] EF_INFOBOX_LEGACY = new byte[]{-17, 1};
    public static final byte[] EF_INFOBOX = new byte[]{-64, 2};
    public static final byte[] AID_SVSIG_CERT = new byte[]{-48, 64, 0, 0, 23, 0, 16, 1};
    public static final byte[] EF_SVSIG_CERT_CA = new byte[]{47, 1};
    public static final byte[] EF_SVSIG_CERT = new byte[]{47, 2};
    public static final byte[] AID_DF_SS = new byte[]{-48, 64, 0, 0, 23, 0, 18, 1};
    public static final byte[] AID_DF_SS_ASIGN = new byte[]{-48, 64, 0, 0, 34, 0, 1};
    public static final byte[] EF_C_X509_CH_DS = new byte[]{-64, 0};
    public static final byte[] EF_C_X509_CA_CS_DS = new byte[]{-58, 8};
    public static final byte KID_PIN_SS = -127;
    public static final byte[] AID_DF_GS = new byte[]{-48, 64, 0, 0, 23, 0, 19, 1};
    public static final byte[] AID_DF_GS_ASIGN = new byte[]{-48, 64, 0, 0, 34, 0, 2};
    public static final byte[] EF_C_X509_CH_AUT = new byte[]{47, 1};
    public static final byte[] EF_C_X509_CA_CS = new byte[]{47, 2};
    public static final byte KID_PIN_CARD = 1;
    public static final byte KID_PUK_CARD = 2;
    protected double version = 1.1;
    protected int generation = 2;
    protected String friendlyName = "G1";
    protected PinInfo cardPinInfo;
    protected PinInfo cardPukInfo = null;
    protected PinInfo ssPinInfo;

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        block15: {
            super.init(card, cardTerminal);
            this.log.info("STARCOS card found");
            CardChannel cardChannel = this.getCardChannel();
            try {
                this.execSELECT_MF(cardChannel);
                this.execSELECT_FID(cardChannel, EF_VERSION);
                byte[] byArray = ISO7816Utils.readRecord(cardChannel, 1);
                byte[] byArray2 = card.getATR().getBytes();
                if (byArray[0] == -91 && byArray[2] == 83) {
                    this.version = (double)(0xF & byArray[4]) + (double)(0xF0 & byArray[5]) / 160.0 + (double)(0xF & byArray[5]) / 100.0;
                    String string = this.friendlyName = this.version < 1.2 ? "<= G2" : "G3+";
                    if (this.version != 1.2) break block15;
                    byte[] byArray3 = card.getATR().getHistoricalBytes();
                    for (int i = 1; i < byArray3.length; ++i) {
                        if ((byArray3[i] & 0xF0) == 80) {
                            this.generation = byArray3[i + 2];
                            break;
                        }
                        i += byArray3[i] & 0xF;
                        this.friendlyName = "G" + this.generation;
                    }
                    if (this.generation == 3) {
                        this.execSELECT_AID(cardChannel, AID_INFOBOX);
                        try {
                            this.execSELECT_FID(cardChannel, EF_INFOBOX);
                            this.friendlyName = "G3b";
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.friendlyName = "G3a";
                        }
                    }
                    if (this.generation == 4) {
                        this.friendlyName = "G4";
                    }
                    break block15;
                }
                if (byArray2[12] == 65 && byArray2[13] == 1) {
                    this.version = 1.2;
                    this.generation = 4;
                    if ((byArray2[16] & 0xFF) == 201 && (byArray2[17] & 0xFF) == 3) {
                        this.friendlyName = "a.sign premium";
                        this.friendlyName = this.friendlyName + " (G1 CardOS5.3)";
                        this.log.info("A-TRUST a.sign premium found, first generation with CardOS 5.3");
                        this.execSELECT_AID(cardChannel, AID_INFOBOXG4);
                    } else {
                        this.friendlyName = this.friendlyName + " (G1)";
                        this.log.info("A-TRUST a.sign premium found, first generation");
                    }
                }
            }
            catch (CardException cardException) {
                this.log.warn("Failed to execute command.", cardException);
            }
            catch (SignatureCardException signatureCardException) {
                this.log.warn("Failed to execute command.", signatureCardException);
            }
        }
        this.cardPinInfo = new PinInfo(4, 12, "[0-9]", "at/gv/egiz/smcc/STARCOSCard", "card.pin", 1, null, 10);
        this.ssPinInfo = this.friendlyName.matches("^a.sign premium.*") ? new PinInfo(6, 12, "[0-9]", "at/gv/egiz/smcc/STARCOSCard", "sig.pin", -127, AID_DF_SS_ASIGN, this.version < 1.2 ? 3 : 10) : new PinInfo(6, 12, "[0-9]", "at/gv/egiz/smcc/STARCOSCard", "sig.pin", -127, AID_DF_SS, this.version < 1.2 ? 3 : 10);
        if (SignatureCardFactory.ENFORCE_RECOMMENDED_PIN_LENGTH) {
            this.cardPinInfo.setRecLength(4);
            if (this.cardPukInfo != null) {
                this.cardPukInfo.setRecLength(10);
            }
            this.ssPinInfo.setRecLength(6);
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        byte[] byArray;
        byte[] byArray2;
        if (keyboxName == SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            byArray2 = this.friendlyName.matches("^a.sign premium.*") ? AID_DF_SS_ASIGN : AID_DF_SS;
            byArray = EF_C_X509_CH_DS;
        } else if (keyboxName == SignatureCard.KeyboxName.CERTIFIED_KEYPAIR) {
            byArray2 = this.friendlyName.matches("^a.sign premium.*") ? AID_DF_GS_ASIGN : AID_DF_GS;
            byArray = EF_C_X509_CH_AUT;
        } else {
            throw new IllegalArgumentException("Keybox " + keyboxName + " not supported.");
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, byArray2);
            this.execSELECT_FID(cardChannel, byArray);
            byte[] byArray3 = ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
            if (byArray3 == null) {
                throw new NotActivatedException();
            }
            return byArray3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        try {
            byte[] byArray;
            if ("IdentityLink".equals(string)) {
                CardChannel cardChannel = this.getCardChannel();
                if (this.friendlyName.matches("^a.sign premium.*")) {
                    this.execSELECT_AID(cardChannel, AID_INFOBOXG4);
                } else {
                    this.execSELECT_AID(cardChannel, AID_INFOBOX);
                }
                try {
                    this.execSELECT_FID(cardChannel, EF_INFOBOX);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.debug("Not an eCard G3b, falling back to legacy FID for EF_Infobox.");
                    this.execSELECT_FID(cardChannel, EF_INFOBOX_LEGACY);
                }
                InfoboxContainer infoboxContainer = null;
                while (infoboxContainer == null) {
                    try {
                        TransparentFileInputStream transparentFileInputStream = ISO7816Utils.openTransparentFileInputStream(cardChannel, -1);
                        infoboxContainer = new InfoboxContainer(transparentFileInputStream, 48);
                    }
                    catch (IOException iOException) {
                        if (iOException.getCause() instanceof SecurityStatusNotSatisfiedException) {
                            this.verifyPINLoop(cardChannel, this.cardPinInfo, pINGUI);
                            continue;
                        }
                        this.log.warn("Failed to read infobox.", iOException);
                        throw new SignatureCardException("Failed to read infobox.", iOException);
                    }
                }
                for (Infobox infobox : infoboxContainer.getInfoboxes()) {
                    if (infobox.getTag() != 1) continue;
                    if (infobox.isEncrypted()) {
                        if (this.friendlyName.matches("^a.sign premium.*")) {
                            this.execSELECT_AID(cardChannel, AID_DF_GS_ASIGN);
                        } else {
                            this.execSELECT_AID(cardChannel, AID_DF_GS);
                        }
                        byte[] byArray2 = this.generation < 4 ? new byte[]{-124, 3, -128, 3, 0, -128, 1, -127} : new byte[]{-124, 1, -125, -107, 1, 64, -128, 1, 16};
                        this.execMSE(cardChannel, 65, 184, byArray2);
                        byte[] byArray3 = null;
                        while (true) {
                            try {
                                byArray3 = this.execPSO_DECIPHER(cardChannel, infobox.getEncryptedKey());
                            }
                            catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                                this.verifyPINLoop(cardChannel, this.cardPinInfo, pINGUI);
                                continue;
                            }
                            break;
                        }
                        return infobox.decipher(byArray3);
                    }
                    return infobox.getData();
                }
                throw new NotActivatedException();
            }
            if ("Status".equals(string)) {
                CardChannel cardChannel = this.getCardChannel();
                this.execSELECT_AID(cardChannel, AID_SV_PERSONENDATEN);
                this.execSELECT_FID(cardChannel, FID_STATUS);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    for (int i = 1; i <= 5; ++i) {
                        byte[] byArray4 = ISO7816Utils.readRecord(cardChannel, i);
                        byteArrayOutputStream.write(byArray4);
                    }
                }
                catch (IOException iOException) {
                    throw new SignatureCardException("Failed to read infobox '" + string + "'.", iOException);
                }
                return byteArrayOutputStream.toByteArray();
            }
            if ("EHIC".equals(string)) {
                byArray = FID_EHIC;
            } else if ("Grunddaten".equals(string)) {
                byArray = FID_GRUNDDATEN;
            } else if ("SV-Personenbindung".equals(string)) {
                byArray = FID_SV_PERSONENBINDUNG;
            } else {
                throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
            }
            CardChannel cardChannel = this.getCardChannel();
            if (this.friendlyName.matches("^a.sign premium.*")) {
                this.execSELECT_AID(cardChannel, AID_INFOBOXG4);
            } else {
                this.execSELECT_AID(cardChannel, AID_SV_PERSONENDATEN);
            }
            this.execSELECT_FID(cardChannel, byArray);
            return ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException(fileNotFoundException);
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        byte[] byArray;
        MessageDigest messageDigest;
        byte[] byArray2;
        ByteArrayOutputStream byteArrayOutputStream;
        block41: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byArray2 = null;
            messageDigest = null;
            byArray = null;
            if (this.generation < 4) {
                byteArrayOutputStream.write(new byte[]{-124, 3, -128});
            }
            try {
                if (string == null || "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(string)) {
                    byteArrayOutputStream.write(new byte[]{2, 0});
                    if (this.version < 1.2) {
                        byteArrayOutputStream.write(new byte[]{-119, 3, 19, 53, 16});
                    } else if (this.generation < 4) {
                        byteArrayOutputStream.write(new byte[]{-128, 1, 4});
                        byArray2 = new byte[]{-128, 1, 16};
                    } else {
                        byteArrayOutputStream.write(new byte[]{-124, 1, -126});
                        byteArrayOutputStream.write(new byte[]{-107, 1, 64});
                    }
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break block41;
                }
                if (this.version >= 1.2 && "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
                    if (this.generation < 4) {
                        byteArrayOutputStream.write(new byte[]{3, 0});
                        byteArrayOutputStream.write(new byte[]{-128, 1, 2});
                        byArray2 = new byte[]{-128, 1, 16};
                    } else {
                        byteArrayOutputStream.write(new byte[]{-124, 1, -125});
                        byteArrayOutputStream.write(new byte[]{-107, 1, 64});
                        byteArrayOutputStream.write(new byte[]{-128, 1, 16});
                        byArray = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
                    }
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break block41;
                }
                if (this.version >= 1.2 && "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256".equals(string)) {
                    if (this.generation < 4) {
                        byteArrayOutputStream.write(new byte[]{2, 0});
                        byteArrayOutputStream.write(new byte[]{-128, 1, 4});
                        byArray2 = new byte[]{-128, 1, 64};
                    } else {
                        byteArrayOutputStream.write(new byte[]{-124, 1, -126});
                        byteArrayOutputStream.write(new byte[]{-107, 1, 64});
                    }
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block41;
                }
                if (this.version >= 1.2 && "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(string)) {
                    if (this.generation < 4) {
                        byteArrayOutputStream.write(new byte[]{3, 0});
                        byteArrayOutputStream.write(new byte[]{-128, 1, 2});
                        byArray2 = new byte[]{-128, 1, 64};
                    } else {
                        byteArrayOutputStream.write(new byte[]{-124, 1, -125});
                        byteArrayOutputStream.write(new byte[]{-107, 1, 64});
                        byteArrayOutputStream.write(new byte[]{-128, 1, 16});
                        byArray = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
                    }
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block41;
                }
                if ("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160".equals(string)) {
                    byteArrayOutputStream.write(new byte[]{2, 0});
                    if (this.version < 1.2) {
                        byteArrayOutputStream.write(new byte[]{-119, 3, 19, 53, 16});
                    } else if (this.generation < 4) {
                        byteArrayOutputStream.write(new byte[]{-128, 1, 4});
                        byArray2 = new byte[]{-119, 2, 20, 48};
                    } else {
                        throw new SignatureCardException("e-card " + this.friendlyName + " does not support signature algorithm " + string + ".");
                    }
                    messageDigest = MessageDigest.getInstance("RIPEMD160");
                    break block41;
                }
                throw new SignatureCardException("e-card " + this.friendlyName + " does not support signature algorithm " + string + ".");
            }
            catch (CryptoException cryptoException) {
                this.log.error("Failed to get MessageDigest.", cryptoException);
                throw new SignatureCardException(cryptoException);
            }
        }
        byte[] byArray3 = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray3)) != -1) {
            messageDigest.update(byArray3, 0, n);
        }
        byArray3 = messageDigest.digest();
        if (byArray != null) {
            byte[] byArray4 = new byte[byArray.length + byArray3.length];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length, byArray3.length);
            byArray3 = byArray4;
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName)) {
                this.execSELECT_MF(cardChannel);
                if (this.friendlyName.matches("^a.sign premium.*")) {
                    this.execSELECT_AID(cardChannel, AID_DF_SS_ASIGN);
                } else {
                    this.execSELECT_AID(cardChannel, AID_DF_SS);
                }
                this.verifyPINLoop(cardChannel, this.ssPinInfo, pINGUI);
                if (this.generation < 4) {
                    this.execMSE(cardChannel, 65, 182, byteArrayOutputStream.toByteArray());
                }
                if (this.version < 1.2) {
                    this.execPSO_HASH(cardChannel, byArray3);
                    return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, null);
                }
                if (byArray2 != null) {
                    this.execMSE(cardChannel, 65, 170, byArray2);
                }
                return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, byArray3);
            }
            if (SignatureCard.KeyboxName.CERTIFIED_KEYPAIR.equals(keyboxName)) {
                if (this.friendlyName.matches("^a.sign premium.*")) {
                    this.execSELECT_AID(cardChannel, AID_DF_GS_ASIGN);
                } else {
                    this.execSELECT_AID(cardChannel, AID_DF_GS);
                }
                this.execMSE(cardChannel, 65, 182, byteArrayOutputStream.toByteArray());
                if (this.version >= 1.2 && byArray2 != null) {
                    this.execMSE(cardChannel, 65, 170, byArray2);
                }
                if (this.generation < 4) {
                    this.execPSO_HASH(cardChannel, byArray3);
                }
                while (true) {
                    try {
                        if (this.generation < 4) {
                            return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, null);
                        }
                        return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, byArray3);
                    }
                    catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                        this.verifyPINLoop(cardChannel, this.cardPinInfo, pINGUI);
                        continue;
                    }
                    break;
                }
            }
            throw new IllegalArgumentException("KeyboxName '" + keyboxName + "' not supported.");
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    @Override
    @Exclusive
    public void verifyPIN(PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, CancelledException, TimeoutException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            if (pinInfo.getContextAID() != null) {
                this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
            }
            this.verifyPINLoop(cardChannel, pinInfo, pINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to verify PIN.", cardException);
            throw new SignatureCardException("Failed to verify PIN.", cardException);
        }
    }

    @Override
    @Exclusive
    public void changePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, CancelledException, TimeoutException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            if (pinInfo.getContextAID() != null) {
                this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
            }
            this.changePINLoop(cardChannel, pinInfo, modifyPINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to change PIN.", cardException);
            throw new SignatureCardException("Failed to change PIN.", cardException);
        }
    }

    @Override
    @Exclusive
    public void activatePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, CancelledException, TimeoutException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            if (pinInfo.getContextAID() != null) {
                this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
            }
            this.activatePIN(cardChannel, pinInfo, modifyPINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to activate PIN.", cardException);
            throw new SignatureCardException("Failed to activate PIN.", cardException);
        }
    }

    @Override
    public void unblockPIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.unblockPINLoop(cardChannel, pinInfo, modifyPINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to activate PIN.", cardException);
            throw new SignatureCardException("Failed to activate PIN.", cardException);
        }
    }

    @Override
    public void reset() throws SignatureCardException {
        try {
            super.reset();
            this.log.debug("Select MF (e-card workaround).");
            CardChannel cardChannel = this.getCardChannel();
            ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 0, 12));
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Failed to select MF after RESET: SW=" + Integer.toHexString(responseAPDU.getSW()) + ".");
            }
        }
        catch (CardException cardException) {
            this.log.error("Failed to select MF after RESET: " + cardException.getMessage(), cardException);
            throw new SignatureCardException("Failed to select MF after RESET");
        }
    }

    @Override
    public PinInfo[] getPinInfos() throws SignatureCardException {
        if (this.version >= 1.2) {
            this.getCertificate(SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR, null);
        }
        PinInfo[] pinInfoArray = this.cardPukInfo != null ? new PinInfo[]{this.cardPinInfo, this.cardPukInfo, this.ssPinInfo} : new PinInfo[]{this.cardPinInfo, this.ssPinInfo};
        CardChannel cardChannel = this.getCardChannel();
        for (PinInfo pinInfo : pinInfoArray) {
            if (pinInfo.getState() == PinInfo.STATE.UNKNOWN) {
                try {
                    this.log.debug("Query pin status for {}.", (Object)pinInfo.getLocalizedName());
                    if (pinInfo.getContextAID() != null) {
                        this.execSELECT_AID(cardChannel, pinInfo.getContextAID());
                    }
                    this.verifyPIN(cardChannel, pinInfo, null, 0);
                }
                catch (Exception exception) {
                    this.log.trace("Failed to execute command.", exception);
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("assume pin status {} to be up to date", (Object)pinInfo.getState());
        }
        return pinInfoArray;
    }

    public String toString() {
        if (this.friendlyName.matches("^a.sign premium.*")) {
            return this.friendlyName;
        }
        return "e-card version " + this.version + " (" + this.friendlyName + ")";
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = this.verifyPIN(cardChannel, pinInfo, null, -1);
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected void changePINLoop(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = this.verifyPIN(cardChannel, pinInfo, null, -1);
        while ((n = this.changePIN(cardChannel, pinInfo, modifyPINGUI, n)) > 0) {
        }
    }

    protected void unblockPINLoop(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.unblockPIN(cardChannel, pinInfo, modifyPINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 8, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4);
        ResponseAPDU responseAPDU = pINGUI != null ? this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n) : cardChannel.transmit(new CommandAPDU(0, 32, 0, pinInfo.getKID()));
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() == 27011 || responseAPDU.getSW() == 25536) {
            pinInfo.setBlocked();
            throw new LockedException();
        }
        if (responseAPDU.getSW() == 27012 || responseAPDU.getSW() == 27013) {
            pinInfo.setNotActive();
            throw new NotActivatedException();
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        if (this.version >= 1.2 && responseAPDU.getSW() == 25600) {
            String string = "VERIFY failed, card not activated. SW=0x6400";
            this.log.error(string);
            pinInfo.setNotActive();
            throw new SignatureCardException(string);
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.error(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected int changePIN(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI, int n) throws CancelledException, InterruptedException, CardException, SignatureCardException {
        ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec = new ChangeReferenceDataAPDUSpec(new byte[]{0, 36, 0, pinInfo.getKID(), 16, 32, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4, 8);
        ResponseAPDU responseAPDU = this.reader.modify(cardChannel, changeReferenceDataAPDUSpec, modifyPINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() == 27011) {
            pinInfo.setBlocked();
            throw new LockedException();
        }
        if (responseAPDU.getSW() == 27012) {
            pinInfo.setNotActive();
            throw new NotActivatedException();
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        String string = "CHANGE REFERENCE DATA failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.error(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected int activatePIN(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws SignatureCardException, InterruptedException, CardException {
        ResponseAPDU responseAPDU;
        Object object;
        if (this.version < 1.2) {
            object = new NewReferenceDataAPDUSpec(new byte[]{0, 36, 1, pinInfo.getKID(), 8, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4);
            responseAPDU = this.reader.modify(cardChannel, (NewReferenceDataAPDUSpec)object, modifyPINGUI, pinInfo);
        } else {
            object = this.generation < 4 ? new NewReferenceDataAPDUSpec(new byte[]{0, 36, 0, pinInfo.getKID(), 16, 38, 18, 52, 86, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4) : new NewReferenceDataAPDUSpec(new byte[]{0, 36, 0, pinInfo.getKID(), 16, 37, 18, 52, 95, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4);
            ((NewReferenceDataAPDUSpec)object).setPinInsertionOffsetNew(8);
            responseAPDU = this.reader.modify(cardChannel, (NewReferenceDataAPDUSpec)object, modifyPINGUI, pinInfo);
        }
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        object = "CHANGE REFERENCE DATA failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.error((String)object);
        pinInfo.setUnknown();
        throw new SignatureCardException((String)object);
    }

    protected int unblockPIN(CardChannel cardChannel, PinInfo pinInfo, ModifyPINGUI modifyPINGUI, int n) throws SignatureCardException, InterruptedException, CardException {
        if (this.version < 1.2) {
            throw new SignatureCardException("RESET RETRY COUNTER is not supported by this card.");
        }
        ResetRetryCounterAPDUSpec resetRetryCounterAPDUSpec = new ResetRetryCounterAPDUSpec(new byte[]{0, 44, 0, pinInfo.getKID(), 16, 32, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4, 8);
        ResponseAPDU responseAPDU = this.reader.modify(cardChannel, resetRetryCounterAPDUSpec, modifyPINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() == 27012) {
            pinInfo.setNotActive();
            throw new NotActivatedException();
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        String string = "RESET RETRY COUNTER failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.error(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected void execSELECT_MF(CardChannel cardChannel) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 0, 12));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Failed to select MF: SW=" + Integer.toHexString(responseAPDU.getSW()) + ".");
        }
    }

    protected byte[] execSELECT_AID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 4, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected byte[] execSELECT_FID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 2, 4, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void execMSE(CardChannel cardChannel, int n, int n2, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, n, n2, byArray));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:SET failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected void execPSO_HASH(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -112;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 144, 160, byArray2));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO:HASH failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected void execPSO_HASH(CardChannel cardChannel, InputStream inputStream) throws SignatureCardException, CardException {
        int n = 64;
        byte[] byArray = new byte[n];
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(-112);
            byteArrayOutputStream.write(0);
            ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(16, 42, 144, 160, byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream.reset();
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(-128);
                byteArrayOutputStream.write(n2);
                byteArrayOutputStream.write(byArray, 0, n2);
                responseAPDU = cardChannel.transmit(new CommandAPDU(n2 == n ? 16 : 0, 42, 144, 160, byteArrayOutputStream.toByteArray()));
                if (responseAPDU.getSW() != 36864) {
                    throw new SignatureCardException("PSO:HASH failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
                }
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException iOException) {
            throw new SignatureCardException(iOException);
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = byArray != null ? cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, byArray, 256)) : cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO: COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    protected byte[] execPSO_DECIPHER(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = -127;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 128, 134, byArray2, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - DECIPHER failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }
}

