/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PinInfo {
    public static final int UNKNOWN_RETRIES = -1;
    protected final int minLength;
    protected final int maxLength;
    protected int recLength = -1;
    protected final String regexpPattern;
    protected final String resourceBundleName;
    protected final String nameKey;
    protected final byte kid;
    protected final byte[] context_aid;
    protected final int maxRetries;
    protected STATE state = STATE.UNKNOWN;
    protected int retries = -1;

    public PinInfo(int n, int n2, String string, String string2, String string3, byte by, byte[] byArray, int n3) {
        this.minLength = n;
        this.maxLength = n2;
        this.regexpPattern = string;
        this.resourceBundleName = string2;
        this.nameKey = string3 + ".name";
        this.kid = by;
        this.context_aid = byArray;
        this.maxRetries = n3;
    }

    public void setRecLength(int n) {
        this.recLength = n;
    }

    public String getLocalizedName() {
        if (this.resourceBundleName != null) {
            try {
                return ResourceBundle.getBundle(this.resourceBundleName).getString(this.nameKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.nameKey;
    }

    public String getLocalizedName(Locale locale) {
        if (this.resourceBundleName != null) {
            try {
                return ResourceBundle.getBundle(this.resourceBundleName, locale).getString(this.nameKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.nameKey;
    }

    public String getLocalizedLength() {
        if (this.recLength > 0) {
            return "" + this.recLength;
        }
        if (this.maxLength == this.minLength) {
            return "" + this.minLength;
        }
        if (this.maxLength > this.minLength) {
            return this.minLength + "-" + this.maxLength;
        }
        return this.minLength + "+";
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getRecMinLength() {
        return this.recLength >= this.minLength ? this.recLength : this.minLength;
    }

    public int getRecMaxLength() {
        return this.recLength >= this.minLength ? this.recLength : this.maxLength;
    }

    public int getRecLength() {
        return this.recLength;
    }

    public String getRegexpPattern() {
        return this.regexpPattern;
    }

    public byte getKID() {
        return this.kid;
    }

    public byte[] getContextAID() {
        return this.context_aid;
    }

    public STATE getState() {
        return this.state;
    }

    public int getRetries() {
        return this.retries;
    }

    protected void setNotActive() {
        this.state = STATE.NOT_ACTIV;
        this.retries = -1;
    }

    protected void setActive(int n) {
        this.state = STATE.ACTIV;
        this.retries = n;
    }

    protected void setBlocked() {
        this.state = STATE.BLOCKED;
        this.retries = -1;
    }

    protected void setUnknown() {
        this.state = STATE.UNKNOWN;
        this.retries = -1;
    }

    public static enum STATE {
        UNKNOWN,
        ACTIV,
        NOT_ACTIV,
        BLOCKED;

    }
}

