/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.cio.CIOCertificate;
import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import java.io.IOException;
import java.util.Arrays;

public class LtEIDCIOCertificate
extends CIOCertificate {
    private BigInteger offset;
    private byte[] length;

    public LtEIDCIOCertificate(byte[] byArray) throws IOException {
        super(byArray);
        ASN1 aSN1 = new ASN1(byArray);
        byte[] byArray2 = aSN1.getElementAt(aSN1.getSize() - 1).getEncoded();
        if ((byArray2[0] & 0xFF) == 161) {
            int n = (byArray2[1] & 0xF0) == 128 ? (byArray2[1] & 0xF) + 2 : 2;
            ASN1 aSN12 = new ASN1(Arrays.copyOfRange(byArray2, n, byArray2.length));
            this.offset = aSN12.getElementAt(0).getElementAt(1).gvBigInteger();
            byte[] byArray3 = aSN12.getElementAt(0).getElementAt(2).gvByteArray();
            if (byArray3 == null || byArray3[0] != byArray3.length - 1) {
                throw new IOException("Cannot extract certificate length information. Unexpected format.");
            }
            this.length = new byte[byArray3[0]];
            System.arraycopy(byArray3, 1, this.length, 0, byArray3[0]);
        }
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public void setOffset(BigInteger bigInteger) {
        this.offset = bigInteger;
    }

    public byte[] getLength() {
        return this.length;
    }

    public void setLength(byte[] byArray) {
        this.length = byArray;
    }
}

