/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import java.nio.ByteBuffer;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCardChannel
extends CardChannel {
    private final Logger log = LoggerFactory.getLogger(LogCardChannel.class);
    protected CardChannel channel;

    public LogCardChannel(CardChannel cardChannel) {
        if (cardChannel == null) {
            throw new NullPointerException();
        }
        this.channel = cardChannel;
    }

    @Override
    public void close() throws CardException {
        this.channel.close();
    }

    @Override
    public Card getCard() {
        return this.channel.getCard();
    }

    @Override
    public int getChannelNumber() {
        return this.channel.getChannelNumber();
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
        if (this.log.isTraceEnabled()) {
            switch (commandAPDU.getINS()) {
                case 32: 
                case 33: 
                case 36: 
                case 44: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(commandAPDU);
                    stringBuilder.append("\n-> ");
                    byte[] byArray = new byte[]{(byte)commandAPDU.getCLA(), (byte)commandAPDU.getINS(), (byte)commandAPDU.getP1(), (byte)commandAPDU.getP2()};
                    stringBuilder.append(this.toString(byArray));
                    if (commandAPDU.getNc() > 0) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.toString(new byte[]{(byte)commandAPDU.getNc()}));
                        for (int i = 0; i < commandAPDU.getNc(); ++i) {
                            stringBuilder.append(":XX");
                        }
                    }
                    if (commandAPDU.getNe() > 0) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.toString(new byte[]{(byte)commandAPDU.getNe()}));
                    }
                    this.log.trace(stringBuilder.toString());
                    break;
                }
                default: {
                    this.log.trace(commandAPDU + "\n-> " + this.toString(commandAPDU.getBytes()));
                }
            }
            long l = System.currentTimeMillis();
            ResponseAPDU responseAPDU = this.channel.transmit(commandAPDU);
            long l2 = System.currentTimeMillis();
            this.log.trace(responseAPDU + " [" + (l2 - l) + "ms]\n<- " + this.toString(responseAPDU.getBytes()));
            return responseAPDU;
        }
        return this.channel.transmit(commandAPDU);
    }

    @Override
    public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
        if (this.log.isTraceEnabled()) {
            long l = System.currentTimeMillis();
            int n = this.channel.transmit(byteBuffer, byteBuffer2);
            long l2 = System.currentTimeMillis();
            this.log.trace("[" + (l2 - l) + "ms]");
            return n;
        }
        return this.channel.transmit(byteBuffer, byteBuffer2);
    }

    private String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && byArray.length > 0) {
            stringBuffer.append(Integer.toHexString((byArray[0] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[0] & 0xF));
        }
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(Integer.toHexString((byArray[i] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }
}

