/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.cio.CIOCertificate;
import at.gv.egiz.smcc.cio.ObjectDirectory;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIEZertifikatCard
extends AbstractSignatureCard
implements SignatureCard {
    private final Logger log = LoggerFactory.getLogger(LIEZertifikatCard.class);
    public static final byte[] MF = new byte[]{63, 0};
    public static final byte[] AID_SIG = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    public static final byte[] EF_CD = new byte[]{68, 4};
    public static final byte[] PKCS1_PADDING = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    public static final byte KID = -126;
    public static final int STORED_LENGTH = 8;
    protected PinInfo pinInfo = new PinInfo(4, 8, "[0-9]", "at/gv/egiz/smcc/LIEZertifikatCard", "pin", -126, AID_SIG, 3);
    protected String name = "LIEZertifikat";
    ObjectDirectory ef_od = new ObjectDirectory();
    CIOCertificate cioQCert;

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        super.init(card, cardTerminal);
        this.log.debug("initializing {} for ATR {}", (Object)this.name, (Object)this.toString(card.getATR().getBytes()));
    }

    public String toString() {
        return this.name;
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        if (keyboxName != SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            throw new IllegalArgumentException("Keybox " + keyboxName + " not supported");
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, AID_SIG);
            this.ensureCIOQCertificate(cardChannel);
            this.execSELECT_EF(cardChannel, this.cioQCert.getEfidOrPath());
            byte[] byArray = ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
            if (byArray == null) {
                throw new NotActivatedException();
            }
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (IOException iOException) {
            this.log.warn("failed to get certificate info", iOException);
            throw new SignatureCardException(iOException);
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR != keyboxName) {
            throw new SignatureCardException("Card does not support key " + keyboxName + ".");
        }
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            throw new SignatureCardException("Card does not support algorithm " + string + ".");
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PKCS1_PADDING);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SignatureCardException(iOException);
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, AID_SIG);
            this.verifyPINLoop(cardChannel, this.pinInfo, pINGUI);
            this.execMSE_SET(cardChannel, this.getCRT_AT(cardChannel));
            return this.execINTERNAL_AUTHENTICATE(cardChannel, byteArrayOutputStream.toByteArray());
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID()}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    protected byte[] execSELECT_AID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 4, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected byte[] execSELECT_EF(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 2, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void execMSE_SET(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, 65, 164, byArray));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:SET failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execINTERNAL_AUTHENTICATE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 136, 0, 0, byArray, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("INTERNAL AUTHENTICATE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private void ensureCIOQCertificate(CardChannel cardChannel) throws IOException, CardException, NotActivatedException, SignatureCardException {
        String string;
        if (this.cioQCert != null) {
            return;
        }
        List<CIOCertificate> list = this.ef_od.getCD(cardChannel).getCIOs(cardChannel);
        for (CIOCertificate cIOCertificate : list) {
            string = cIOCertificate.getLabel();
            if (string == null || !string.toLowerCase().contains("qualified signature")) continue;
            this.log.debug("found certificate: {} (fid={})", (Object)string, (Object)this.toString(cIOCertificate.getEfidOrPath()));
            this.cioQCert = cIOCertificate;
        }
        if (this.cioQCert == null) {
            for (CIOCertificate cIOCertificate : list) {
                string = cIOCertificate.getLabel();
                if (string == null || !string.toLowerCase().contains("liechtenstein post qualified ca id")) continue;
                this.log.debug("found certificate: {} (fid={})", (Object)string, (Object)this.toString(cIOCertificate.getEfidOrPath()));
                this.cioQCert = cIOCertificate;
            }
        }
        if (this.cioQCert == null) {
            throw new NotActivatedException();
        }
    }

    protected byte[] getCRT_AT(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        this.ensureCIOQCertificate(cardChannel);
        List<CIOCertificate> list = this.ef_od.getPrKD(cardChannel).getCIOs(cardChannel);
        int n = 1;
        for (CIOCertificate cIOCertificate : list) {
            if (Arrays.equals(cIOCertificate.getiD(), this.cioQCert.getiD())) {
                byte[] byArray = new byte[]{-124, 1, (byte)(0x80 | 0x7F & n), -119, 2, 35, 19};
                return byArray;
            }
            ++n;
        }
        this.log.error("no PrK CIO corresponding to QCert {} found", (Object)this.toString(this.cioQCert.getiD()));
        throw new SignatureCardException("could not determine PrK for QCert " + this.toString(this.cioQCert.getiD()));
    }
}

