/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.Infobox;
import at.gv.egiz.smcc.InfoboxException;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TransparentFileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardException;

public class InfoboxContainer {
    public static byte[] HEADER_AIK = new byte[]{65, 73, 75};
    private ArrayList<Infobox> infoboxes = new ArrayList();

    public InfoboxContainer(TransparentFileInputStream transparentFileInputStream, byte by) throws IOException, CardException, SignatureCardException {
        transparentFileInputStream.mark(1);
        int n = transparentFileInputStream.read();
        if (n == -1 || n == 0 || n == 255) {
            return;
        }
        transparentFileInputStream.reset();
        transparentFileInputStream.mark(3);
        byte[] byArray = new byte[3];
        transparentFileInputStream.read(byArray);
        if (Arrays.equals(byArray, HEADER_AIK)) {
            int n2;
            int n3 = transparentFileInputStream.read();
            if (n3 != 1) {
                throw new InfoboxException("Infobox version " + n3 + " not supported.");
            }
            while ((n2 = transparentFileInputStream.read()) != 0) {
                int n4 = transparentFileInputStream.read();
                int n5 = transparentFileInputStream.read() + (transparentFileInputStream.read() << 8);
                byte[] byArray2 = new byte[n5];
                transparentFileInputStream.read(byArray2);
                Infobox infobox = new Infobox(n2, n4, byArray2);
                this.infoboxes.add(infobox);
            }
        } else {
            transparentFileInputStream.reset();
            byte[] byArray3 = ISO7816Utils.readTransparentFileTLV(transparentFileInputStream, by);
            if (byArray3 != null) {
                this.infoboxes.add(new Infobox(1, 0, byArray3));
            }
        }
    }

    public List<Infobox> getInfoboxes() {
        return this.infoboxes;
    }
}

