/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractISCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISVISAElectronCard
extends AbstractISCard
implements SignatureCard {
    private static final byte[] APPLET_ID = new byte[]{-46, 118, 0, 0, -104, 0, 0, 0};
    private static final byte[] PKI_PROFILE = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    private static final String CERTIFICATE_IDENTIFIER = "Undirritun";
    private static final int TRANSFER_BLOCK_SIZE = 128;
    private static final PinInfo PIN_SPEC = new PinInfo(6, 6, "[0-9]", "at/gv/egiz/smcc/ISVISAElectronCard", "sig.pin", 4, new byte[0], -1);
    private final Logger log = LoggerFactory.getLogger(ISVISAElectronCard.class);

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            int n;
            MessageDigest messageDigest;
            this.selectApplet(cardChannel);
            this.selectPKIProfile(cardChannel);
            this.verifyPINLoop(cardChannel, PIN_SPEC, pINGUI);
            this.setMSE(cardChannel);
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
                throw new SignatureCardException(noSuchAlgorithmException);
            }
            byte[] byArray = new byte[messageDigest.getDigestLength()];
            while ((n = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byArray = messageDigest.digest();
            return this.executeSecurityOperation(cardChannel, byArray);
        }
        catch (CardException cardException) {
            cardException.printStackTrace();
            throw new SignatureCardException("Error creating signature.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 6, 0, 0, 0, 0, 0, 0}, 0, 2, 6);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    private byte[] executeSecurityOperation(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        Object object;
        byte[] byArray2 = new byte[256];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = -1;
        }
        byArray2[0] = 0;
        byArray2[1] = 1;
        byArray2[byArray2.length - 1 - ISVISAElectronCard.OID.length - byArray.length] = 0;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        System.arraycopy(OID, 0, byArray2, byArray2.length - OID.length - byArray.length, OID.length);
        byte[] byArray3 = new byte[]{0, 42, -98, -102, 0, 1, 0};
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        boolean bl = false;
        int n = 0;
        while (!bl) {
            boolean bl2 = byArray4.length - n <= 128;
            int n2 = bl2 ? byArray4.length - n : 128;
            object = new byte[n2];
            System.arraycopy(byArray4, n, object, 0, ((byte[])object).length);
            int n3 = bl2 ? -128 : 0;
            CommandAPDU commandAPDU = new CommandAPDU(-128, -86, n3, 0, (byte[])object);
            ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
            }
            if ((n += ((Object)object).length) < byArray4.length) continue;
            bl = true;
        }
        bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!bl) {
            CommandAPDU commandAPDU = new CommandAPDU(-128, -85, 0, 0);
            object = cardChannel.transmit(commandAPDU);
            if (((ResponseAPDU)object).getSW1() == 108) {
                commandAPDU = new CommandAPDU(-128, -85, 0, 0, ((ResponseAPDU)object).getSW2());
                object = cardChannel.transmit(commandAPDU);
            }
            try {
                byteArrayOutputStream.write(((ResponseAPDU)object).getData());
            }
            catch (IOException iOException) {
                throw new SignatureCardException("Error saving card response.", iOException);
            }
            if (((ResponseAPDU)object).getSW() != 25218) continue;
            bl = true;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void setMSE(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, -15, -74, new byte[]{-124, 1, 2});
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Unexpected response to MSE SET: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        this.log.debug("Trying to read certificate..");
        CardChannel cardChannel = this.getCardChannel();
        byte[] byArray = null;
        try {
            this.selectApplet(cardChannel);
            this.selectPKIProfile(cardChannel);
            this.selectDF(cardChannel, new byte[]{67, 4});
            this.selectDF(cardChannel, new byte[]{69, 65});
            byte[] byArray2 = this.executeReadBinary(cardChannel);
            this.selectPKIProfile(cardChannel);
            this.selectDF(cardChannel, new byte[]{68, 4});
            byte[] byArray3 = this.executeReadBinary(cardChannel);
            byArray = this.retrieveSigningCertificate(byArray2, byArray3, CERTIFICATE_IDENTIFIER);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error reading certificate.", cardException);
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Error reading certificate.", iOException);
        }
        return byArray;
    }

    private void selectPKIProfile(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 4, 0, PKI_PROFILE);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Error selecting pki profile. Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void selectDF(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 0, 0, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Error selecting DF. Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private byte[] executeReadBinary(CardChannel cardChannel) throws CardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl) {
            byte[] byArray = SMCCHelper.toByteArray(n2);
            ResponseAPDU responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)(bl2 ? 1 : 0));
            if (responseAPDU.getSW1() == 108) {
                responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)responseAPDU.getSW2());
            }
            if (responseAPDU.getSW() == 25218) {
                bl = true;
            }
            try {
                byteArrayOutputStream.write(responseAPDU.getData());
            }
            catch (IOException iOException) {
                this.log.error("Error executing secure read binary.", iOException);
                throw new CardException("Error reading data from card", iOException);
            }
            n2 = n += responseAPDU.getData().length;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResponseAPDU readFromCard(CardChannel cardChannel, byte by, byte by2, byte by3) throws CardException {
        byte[] byArray = new byte[]{0, -80, by, by2, by3};
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        return responseAPDU;
    }

    @Override
    protected byte[] getAppletID() {
        return APPLET_ID;
    }
}

