/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.CIOCertificateDirectory;
import at.gv.egiz.smcc.FINEIDAODirectory;
import at.gv.egiz.smcc.FINEIDAuthenticationObject;
import at.gv.egiz.smcc.FINEIDCIOCertificateDirectory;
import at.gv.egiz.smcc.FINEIDCIOKeyDirectory;
import at.gv.egiz.smcc.FINEIDEFObjectDirectory;
import at.gv.egiz.smcc.FINEIDUtil;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.cio.CIOCertificate;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import at.gv.egiz.smcc.util.TLVSequence;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FINEIDCard
extends AbstractSignatureCard
implements SignatureCard {
    private static final int EF_OD_PADDING = 255;
    private static final String SIG_CERT_LABEL = "allekirjoitusvarmenne";
    private static final String SIG_KEY_LABEL = "allekirjoitusavain";
    private final Logger log = LoggerFactory.getLogger(FINEIDCard.class);
    protected PinInfo pinInfo = new PinInfo(6, 8, "[0-9]", "at/gv/egiz/smcc/FINEIDCard", "sig.pin", 0, new byte[0], -1);

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            int n;
            MessageDigest messageDigest;
            void var11_14;
            byte[] byArray;
            Object object;
            FINEIDEFObjectDirectory fINEIDEFObjectDirectory = new FINEIDEFObjectDirectory(255);
            fINEIDEFObjectDirectory.selectAndRead(cardChannel);
            FINEIDCIOKeyDirectory fINEIDCIOKeyDirectory = new FINEIDCIOKeyDirectory(fINEIDEFObjectDirectory.getPrKDReferences().get(0));
            fINEIDCIOKeyDirectory.selectAndRead(cardChannel);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            for (CIOCertificate object32 : fINEIDCIOKeyDirectory.getCIOs()) {
                object = object32.getLabel();
                if (object == null || !((String)object).toLowerCase().contains(SIG_KEY_LABEL.toLowerCase())) continue;
                byArray2 = object32.getEfidOrPath();
                byArray3 = object32.getAuthId();
            }
            if (byArray2 == null) {
                throw new SignatureCardException("Could not determine path to private key from PrKD.");
            }
            if (byArray3 == null) {
                throw new SignatureCardException("Could not determine authID of private key from PrKD.");
            }
            FINEIDAODirectory fINEIDAODirectory = new FINEIDAODirectory(fINEIDEFObjectDirectory.getAODReferences().get(0));
            fINEIDAODirectory.selectAndRead(cardChannel);
            Object var11_13 = null;
            object = null;
            for (FINEIDAuthenticationObject fINEIDAuthenticationObject : fINEIDAODirectory.getAOs()) {
                byArray = fINEIDAuthenticationObject.getAuthId();
                if (byArray == null || !Arrays.equals(byArray, byArray3)) continue;
                byte[] byArray4 = fINEIDAuthenticationObject.getPath();
                object = fINEIDAuthenticationObject.getPwdReference();
            }
            if (var11_14 == null) {
                throw new SignatureCardException("Could not determine path to PIN from AOD.");
            }
            if (object == null) {
                throw new SignatureCardException("Could not determine PIN reference from AOD.");
            }
            this.verifyPINLoop(cardChannel, this.pinInfo, pINGUI, (byte[])var11_14, (byte)object[((String)object).length - 1]);
            CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 0, FINEIDUtil.removeMFPath(byArray2));
            ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Could not select private key file DF.");
            }
            this.executeRestoreMSE(cardChannel);
            byArray = new byte[]{-128, 1, 18, -127, 2, byArray2[byArray2.length - 2], byArray2[byArray2.length - 1]};
            this.executeSetMSE(cardChannel, byArray);
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
                throw new SignatureCardException(noSuchAlgorithmException);
            }
            byte[] byArray5 = new byte[messageDigest.getDigestLength()];
            while ((n = inputStream.read(byArray5)) != -1) {
                messageDigest.update(byArray5, 0, n);
            }
            byArray5 = messageDigest.digest();
            byte[] byArray6 = this.executeSign(cardChannel, byArray5);
            return byArray6;
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error creating signature.", cardException);
        }
    }

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            Object object2;
            FINEIDEFObjectDirectory fINEIDEFObjectDirectory = new FINEIDEFObjectDirectory(255);
            fINEIDEFObjectDirectory.selectAndRead(cardChannel);
            byte[] byArray = null;
            for (int i = 0; i < fINEIDEFObjectDirectory.getCDReferences().size(); ++i) {
                object2 = new FINEIDCIOCertificateDirectory(fINEIDEFObjectDirectory.getCDReferences().get(i));
                try {
                    ((CIOCertificateDirectory)object2).selectAndRead(cardChannel);
                }
                catch (IOException iOException) {
                    this.log.debug("Cannot read EF.CD - try next one in list..");
                    continue;
                }
                for (CIOCertificate object3 : ((CIOCertificateDirectory)object2).getCIOs()) {
                    String string = object3.getLabel();
                    if (string == null || !string.toLowerCase().contains(SIG_CERT_LABEL.toLowerCase())) continue;
                    byArray = object3.getEfidOrPath();
                }
            }
            if (byArray == null) {
                throw new SignatureCardException("Could not determine path to certificate.");
            }
            this.log.debug("Read certificate path: " + SMCCHelper.toString(byArray));
            byArray = FINEIDUtil.removeMFPath(byArray);
            CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 0, byArray);
            object2 = cardChannel.transmit(commandAPDU);
            Object object4 = new TLVSequence(((ResponseAPDU)object2).getBytes()).getValue(111);
            byte[] byArray2 = new TLVSequence((byte[])object4).getValue(129);
            return ISO7816Utils.readTransparentFile(cardChannel, this.computeLengthFromByteArray(byArray2));
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error reading certificate from card.", cardException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, byte[] byArray, byte by) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 0, FINEIDUtil.removeMFPath(byArray));
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Cannot select PIN path " + SMCCHelper.toString(byArray) + ": " + Integer.toHexString(responseAPDU.getSW()));
        }
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n, by)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n, byte by) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, by, 8, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 2, 8);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    private void executeRestoreMSE(CardChannel cardChannel) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, -13, 0);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error restoring MSE: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void executeSetMSE(CardChannel cardChannel, byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, 65, -74, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error setting MSE: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private byte[] executeSign(CardChannel cardChannel, byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 42, -98, -102, byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error signing hash: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private int computeLengthFromByteArray(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[byArray.length - 1 - i];
            n += (int)((double)by * Math.pow(256.0, i));
        }
        return n;
    }
}

