/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.CIOCertificateDirectory;
import at.gv.egiz.smcc.FINEIDAuthenticationObject;
import at.gv.egiz.smcc.FINEIDUtil;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TLVSequence;
import iaik.me.asn1.ASN1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FINEIDAODirectory {
    protected static final Logger log = LoggerFactory.getLogger(CIOCertificateDirectory.class);
    protected byte[] fid;
    protected List<FINEIDAuthenticationObject> aos;

    public FINEIDAODirectory(byte[] byArray) {
        this.fid = FINEIDUtil.removeMFPath(byArray);
        this.aos = new ArrayList<FINEIDAuthenticationObject>();
    }

    public void selectAndRead(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, 8, 0, this.fid, 256);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        byte[] byArray = new TLVSequence(responseAPDU.getBytes()).getValue(111);
        byte[] byArray2 = new TLVSequence(byArray).getValue(130);
        if ((byArray2[0] & 5) == 1) {
            this.readAuthenticationObjectsFromTransparentFile(cardChannel);
        }
    }

    protected byte[] doReadTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException {
        return ISO7816Utils.readTransparentFile(cardChannel, -1);
    }

    protected void readAuthenticationObjectsFromTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        int n;
        byte[] byArray = this.doReadTransparentFile(cardChannel);
        int n2 = 0;
        do {
            int n3 = 0;
            int n4 = 0;
            if ((byArray[n2 + 1] & 0xF0) == 128) {
                n4 = byArray[n2 + 1] & 0x7F;
                for (int i = 0; i < n4; ++i) {
                    n3 = (n3 << 8) + (byArray[n2 + i + 2] & 0xFF);
                }
            } else {
                n3 = byArray[n2 + 1] & 0xFF;
            }
            log.trace("read transparent file entry: tag 0x{}, length 0x{}", (Object)Integer.toHexString(byArray[n2]), (Object)Integer.toHexString(n3));
            n = n2 + 2 + n4 + n3;
            this.addAuthenticationObject(Arrays.copyOfRange(byArray, n2, n));
        } while ((n2 = n) < byArray.length && byArray[n2] > 0);
    }

    protected void addAuthenticationObject(byte[] byArray) throws IOException {
        ASN1 aSN1 = new ASN1(byArray);
        FINEIDAuthenticationObject fINEIDAuthenticationObject = new FINEIDAuthenticationObject();
        fINEIDAuthenticationObject.setLabel(aSN1.getElementAt(0).getElementAt(0).gvString());
        fINEIDAuthenticationObject.setAuthId(aSN1.getElementAt(1).getElementAt(0).gvByteArray());
        byte[] byArray2 = aSN1.getElementAt(aSN1.getSize() - 1).getEncoded();
        if ((byArray2[0] & 0xFF) == 161) {
            int n = (byArray2[1] & 0xF0) == 128 ? (byArray2[1] & 0xF) + 2 : 2;
            ASN1 aSN12 = new ASN1(Arrays.copyOfRange(byArray2, n, byArray2.length));
            fINEIDAuthenticationObject.setPath(aSN12.getElementAt(aSN12.getSize() - 1).getElementAt(0).gvByteArray());
            byte[] byArray3 = aSN12.getElementAt(4).getEncoded();
            ASN1 aSN13 = new ASN1(byArray3);
            fINEIDAuthenticationObject.setPwdReference(aSN13.gvByteArray());
        } else {
            log.warn("expected CONTEXTSPECIFIC, got 0x{}", (Object)Integer.toHexString(byArray2[0]));
        }
        log.debug("adding {}", (Object)fINEIDAuthenticationObject);
        this.aos.add(fINEIDAuthenticationObject);
    }

    public List<FINEIDAuthenticationObject> getAOs() {
        return this.aos;
    }
}

