/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.CIOCertificateDirectory;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import at.gv.egiz.smcc.util.TLVSequence;
import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class DNIeCIOCertificateDirectory
extends CIOCertificateDirectory {
    protected static final boolean RETRIEVE_AUTH_ID_FROM_ASN1 = Boolean.FALSE;

    public DNIeCIOCertificateDirectory(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void selectAndRead(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, 0, 0, this.fid, 256);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error selecting DNIeCIOCertificateDeirectory: " + Integer.toHexString(responseAPDU.getSW()));
        }
        byte[] byArray = new TLVSequence(responseAPDU.getBytes()).getValue(111);
        byte[] byArray2 = new TLVSequence(byArray).getValue(133);
        if (byArray2.length < 5 || byArray2[0] != 1 || byArray2[1] != this.fid[0] || byArray2[2] != this.fid[1]) {
            throw new CardException("Error reading CDF - invalid FCI: " + SMCCHelper.toString(responseAPDU.getData()));
        }
        this.readCIOCertificatesFromTransparentFile(cardChannel);
    }

    @Override
    protected byte[] doReadTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException {
        return ISO7816Utils.readTransparentFile(cardChannel, -1, 239);
    }

    protected boolean retrieveAuthIdFromASN1() {
        return RETRIEVE_AUTH_ID_FROM_ASN1;
    }
}

