/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.ACOSCard;
import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PINFormatException;
import at.gv.egiz.smcc.PINMgmtSignatureCard;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.cio.ObjectDirectory;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.SMCCHelper;
import iaik.me.asn1.ASN1;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CypriotEID
extends AbstractSignatureCard
implements PINMgmtSignatureCard {
    private final Logger log = LoggerFactory.getLogger(ACOSCard.class);
    public static final byte KID_PUK_SIG = 2;
    public static final byte KID_PIN_SIG = 1;
    public static final byte[] CD_ID = new byte[]{112, 5};
    public static final byte[] MF_ID = new byte[]{63, 0};
    public static final byte[] ADF_AWP_ID = new byte[]{-83, -15};
    public static final byte[] AID_SIG = new byte[]{-96, 0, 0, 0, 119, 1, 8, 0, 7, 0, 0, -2, 0, 0, 1, 0};
    PinInfo pinPinInfo;
    PinInfo pukPinInfo;
    ObjectDirectory od;
    protected byte[] cert_id;

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        super.init(card, cardTerminal);
        this.log.info("Cypriot EID found");
        this.pinPinInfo = new PinInfo(4, 64, "[0-9]", "at/gv/egiz/smcc/CypriotEID", "sig.pin", 1, AID_SIG, 3);
        this.pukPinInfo = new PinInfo(4, 64, "[0-9]", "at/gv/egiz/smcc/CypriotEID", "sig.puk", 2, AID_SIG, 3);
        try {
            this.exec_readcd(this.getCardChannel());
        }
        catch (CardException cardException) {
            this.log.warn("Failed to read the certificate ID", cardException);
            this.cert_id = null;
        }
        catch (SignatureCardException signatureCardException) {
            this.log.warn("Failed to read the certificate ID", signatureCardException);
            this.cert_id = null;
        }
        catch (IOException iOException) {
            this.log.warn("Failed to read the certificate ID", iOException);
            this.cert_id = null;
        }
    }

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            return this.exec_readcert(cardChannel);
        }
        catch (CardException cardException) {
            this.log.info("Failed to get the certificate.", cardException);
            throw new SignatureCardException("Failed to get the certificate.", cardException);
        }
        catch (IOException iOException) {
            this.log.info("Failed to get the certificate.", iOException);
            throw new SignatureCardException("Failed to get the certificate.", iOException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        byte by;
        block9: {
            by = 0;
            try {
                if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName) && (string == null || "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string))) {
                    by = 18;
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    break block9;
                }
                if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR.equals(keyboxName) && "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(string)) {
                    by = 65;
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block9;
                }
                throw new SignatureCardException("Card does not support signature algorithm " + string + ".");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
                throw new SignatureCardException(noSuchAlgorithmException);
            }
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        CardChannel cardChannel = this.getCardChannel();
        try {
            try {
                this.exec_selectADF(cardChannel);
                this.exec_MSE(cardChannel, by);
                return this.exec_sign(cardChannel, byArray);
            }
            catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                this.exec_selectADF(cardChannel);
                this.exec_MSE(cardChannel, by);
                this.verifyPINLoop(cardChannel, this.pinPinInfo, pINGUI);
                return this.exec_sign(cardChannel, byArray);
            }
        }
        catch (CardException cardException) {
            this.log.info("Failed to create digital signature", cardException);
            throw new SignatureCardException("Failed to create digital signature", cardException);
        }
    }

    @Override
    public PinInfo[] getPinInfos() throws SignatureCardException {
        PinInfo[] pinInfoArray = new PinInfo[]{this.pinPinInfo, this.pukPinInfo};
        CardChannel cardChannel = this.getCardChannel();
        for (PinInfo pinInfo : pinInfoArray) {
            if (pinInfo.getState() == PinInfo.STATE.UNKNOWN) {
                try {
                    this.log.debug("Query pin status for {}.", (Object)pinInfo.getLocalizedName());
                    this.testPIN(cardChannel, pinInfo);
                }
                catch (Exception exception) {
                    this.log.trace("Failed to execute command.", exception);
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("assume pin status {} to be up to date", (Object)pinInfo.getState());
        }
        return pinInfoArray;
    }

    @Override
    public void verifyPIN(PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, CancelledException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.exec_selectADF(cardChannel);
            this.verifyPINLoop(cardChannel, pinInfo, pINGUI);
        }
        catch (CardException cardException) {
            this.log.info("Failed to verify PIN.", cardException);
            throw new SignatureCardException("Failed to verify PIN.", cardException);
        }
    }

    public String toString() {
        return "Oberthur Thechnologies ID-ONE Token SLIM";
    }

    @Override
    public void changePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, CancelledException, PINFormatException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.unblockPINLoop(cardChannel, modifyPINGUI, pinInfo);
        }
        catch (CardException cardException) {
            this.log.info("Failed to change PIN.", cardException);
            throw new SignatureCardException("Failed to change PIN.", cardException);
        }
    }

    @Override
    public void activatePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        this.log.error("ACTIVATE PIN not supported by Cypriotic EID");
        throw new SignatureCardException("PIN activation not supported by this card.");
    }

    @Override
    public void unblockPIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.unblockPINLoop(cardChannel, modifyPINGUI, pinInfo);
        }
        catch (CardException cardException) {
            this.log.info("Failed to unblock PIN.", cardException);
            throw new SignatureCardException("Failed to unblock PIN.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected void unblockPINLoop(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.exec_unblockPIN(cardChannel, modifyPINGUI, pinInfo)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = pINGUI.providePIN(pinInfo, pinInfo.retries);
        byte[] byArray = this.encodePIN(cArray);
        this.exec_selectADF(cardChannel);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 32, 0, (int)pinInfo.getKID(), byArray));
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                pinInfo.setBlocked();
                throw new LockedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected int testPIN(CardChannel cardChannel, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        this.exec_selectADF(cardChannel);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 32, 0, pinInfo.getKID()));
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            pinInfo.setActive(0xF & responseAPDU.getSW());
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                pinInfo.setBlocked();
                throw new LockedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    private byte[] encodePIN(char[] cArray) {
        return Charset.forName("ASCII").encode(CharBuffer.wrap(cArray)).array();
    }

    protected int exec_unblockPIN(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = modifyPINGUI.providePUK(pinInfo, this.pukPinInfo, this.pukPinInfo.retries);
        char[] cArray2 = modifyPINGUI.provideNewPIN(pinInfo);
        byte[] byArray = this.encodePIN(cArray);
        byte[] byArray2 = this.encodePIN(cArray2);
        this.exec_selectADF(cardChannel);
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 32, 0, (int)this.pukPinInfo.getKID(), byArray));
        if (responseAPDU.getSW() != 36864) {
            if (responseAPDU.getSW() >> 4 == 1596) {
                this.pukPinInfo.setActive(0xF & responseAPDU.getSW());
                return 0xF & responseAPDU.getSW();
            }
            if (responseAPDU.getSW() == 27011) {
                this.pukPinInfo.setBlocked();
                throw new LockedException();
            }
            String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
            this.log.info(string);
            this.pukPinInfo.setUnknown();
            throw new SignatureCardException(string);
        }
        this.pukPinInfo.setActive(this.pukPinInfo.maxRetries);
        responseAPDU = cardChannel.transmit(new CommandAPDU(0, 44, 2, (int)pinInfo.getKID(), byArray2));
        if (responseAPDU.getSW() == 36864) {
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        String string = "SET PIN failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        pinInfo.setUnknown();
        throw new SignatureCardException(string);
    }

    protected byte[] exec_readcert(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        if (this.cert_id == null) {
            this.exec_readcd(cardChannel);
        }
        if (this.cert_id == null) {
            throw new CardException("Failed to read the certificate id");
        }
        this.exec_selectADF(cardChannel);
        this.exec_selectFILE(cardChannel, this.cert_id);
        return this.exec_readBinary(cardChannel);
    }

    protected void exec_readcd(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        this.exec_selectADF(cardChannel);
        this.exec_selectFILE(cardChannel, CD_ID);
        byte[] byArray = this.exec_readBinary(cardChannel);
        ASN1 aSN1 = new ASN1(byArray);
        for (int i = 0; i < aSN1.getSize(); ++i) {
            ASN1 aSN12;
            ASN1 aSN13 = aSN1.getElementAt(i);
            if (aSN13.getTagClass() != Integer.MIN_VALUE || aSN13.getTypeOnly() != 1 || (aSN12 = aSN13.gvASN1().getElementAt(0).getElementAt(0)).getTypeOnly() != 4) continue;
            this.cert_id = aSN12.gvByteArray();
            return;
        }
        this.cert_id = null;
        throw new CardException("Failed to read the certificate ID.");
    }

    protected void exec_selectADF(CardChannel cardChannel) throws CardException, SignatureCardException {
        this.exec_selectFILE(cardChannel, MF_ID);
        this.exec_selectFILE(cardChannel, ADF_AWP_ID);
    }

    protected byte[] exec_selectFILE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 1, 12, byArray));
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select File=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void exec_MSE(CardChannel cardChannel, byte by) throws CardException {
        byte[] byArray = new byte[]{-128, 1, by, -124, 1, -127};
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, 65, 182, byArray));
    }

    protected byte[] exec_sign(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, byArray));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO - COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    protected byte[] exec_readBinary(CardChannel cardChannel) throws CardException, IOException, SignatureCardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n = 0;
        do {
            Object object;
            byte by;
            byte by2;
            ResponseAPDU responseAPDU;
            if ((responseAPDU = cardChannel.transmit(new CommandAPDU(0, 176, (int)(by2 = (byte)(n >> 8)), (int)(by = (byte)n), 0))).getSW() != 36864) {
                object = "Failed to read binary SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
                this.log.info((String)object);
                throw new SignatureCardException((String)object);
            }
            object = responseAPDU.getData();
            byteArrayOutputStream.write((byte[])object);
            bl = ((byte[])object).length == 231;
            n += ((byte[])object).length;
        } while (bl);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }
}

