/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.cio.CIOCertificate;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TLVSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIOCertificateDirectory {
    protected static final Logger log = LoggerFactory.getLogger(CIOCertificateDirectory.class);
    protected byte[] fid;
    protected List<CIOCertificate> cios;

    public CIOCertificateDirectory(byte[] byArray) {
        this.fid = byArray;
        this.cios = new ArrayList<CIOCertificate>();
    }

    public void selectAndRead(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        byte[] byArray = this.executeSelect(cardChannel);
        if ((byArray[0] & 4) > 0) {
            this.readCIOCertificatesFromRecords(cardChannel, byArray);
        } else if ((byArray[0] & 5) == 1) {
            this.readCIOCertificatesFromTransparentFile(cardChannel);
        }
    }

    protected byte[] executeSelect(CardChannel cardChannel) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, 2, 4, this.fid, 256);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        byte[] byArray = new TLVSequence(responseAPDU.getBytes()).getValue(98);
        byte[] byArray2 = new TLVSequence(byArray).getValue(130);
        return byArray2;
    }

    protected void readCIOCertificatesFromRecords(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException, IOException {
        for (int i = 1; i < byArray[byArray.length - 1]; ++i) {
            log.trace("read CIO record {}", (Object)i);
            byte[] byArray2 = ISO7816Utils.readRecord(cardChannel, i);
            log.trace("{} bytes", (Object)byArray2.length);
            this.addCIOCertificate(byArray2);
        }
    }

    protected byte[] doReadTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException {
        return ISO7816Utils.readTransparentFile(cardChannel, -1);
    }

    protected void readCIOCertificatesFromTransparentFile(CardChannel cardChannel) throws CardException, SignatureCardException, IOException {
        int n;
        byte[] byArray = this.doReadTransparentFile(cardChannel);
        int n2 = 0;
        do {
            int n3 = 0;
            int n4 = 0;
            if ((byArray[n2 + 1] & 0xF0) == 128) {
                n4 = byArray[n2 + 1] & 0x7F;
                for (int i = 0; i < n4; ++i) {
                    n3 = (n3 << 8) + (byArray[n2 + i + 2] & 0xFF);
                }
            } else {
                n3 = byArray[n2 + 1] & 0xFF;
            }
            log.trace("read transparent file entry: tag 0x{}, length 0x{}", (Object)Integer.toHexString(byArray[n2]), (Object)Integer.toHexString(n3));
            n = n2 + 2 + n4 + n3;
            this.addCIOCertificate(Arrays.copyOfRange(byArray, n2, n));
        } while ((n2 = n) < byArray.length && byArray[n2] > 0);
    }

    protected void addCIOCertificate(byte[] byArray) throws IOException {
        CIOCertificate cIOCertificate = new CIOCertificate(byArray);
        log.debug("adding {}", (Object)cIOCertificate);
        this.cios.add(cIOCertificate);
    }

    public List<CIOCertificate> getCIOs() {
        return this.cios;
    }
}

