/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BELPICCard
extends AbstractSignatureCard
implements SignatureCard {
    private final Logger log = LoggerFactory.getLogger(BELPICCard.class);
    public static final byte[] MF = new byte[]{63, 0};
    public static final byte[] DF_BELPIC = new byte[]{-33, 0};
    public static final byte[] DF_ID = new byte[]{-33, 1};
    public static final byte[] SIGN_CERT = new byte[]{80, 57};
    public static final int SIGNATURE_LENGTH = 128;
    public static final byte KID = 1;
    public static final int READ_BUFFER_LENGTH = 256;
    public static final int PINSPEC_SS = 0;
    protected PinInfo ssPinInfo = new PinInfo(4, 12, "[0-9]", "at/gv/egiz/smcc/BELPICCard", "sig.pin", 1, DF_BELPIC, -1);

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        if (keyboxName != SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            throw new IllegalArgumentException("Keybox " + keyboxName + " not supported");
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_FID(cardChannel, MF);
            this.execSELECT_FID(cardChannel, DF_BELPIC);
            this.execSELECT_FID(cardChannel, SIGN_CERT);
            byte[] byArray = ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
            if (byArray == null) {
                throw new NotActivatedException();
            }
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR != keyboxName) {
            throw new SignatureCardException("Card does not support key " + keyboxName + ".");
        }
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            throw new SignatureCardException("Card does not support algorithm " + string + ".");
        }
        byte[] byArray = new byte[]{4, -128, 2, -124, -125};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray2)) != -1) {
            messageDigest.update(byArray2, 0, n);
        }
        byArray2 = messageDigest.digest();
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_FID(cardChannel, MF);
            this.execMSE(cardChannel, 65, 182, byArray);
            this.verifyPINLoop(cardChannel, this.ssPinInfo, pINGUI);
            return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, byArray2);
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    public String toString() {
        return "Belpic Card";
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 8, 32, -1, -1, -1, -1, -1, -1, -1}, 1, 1, 7, 4, 4);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    protected byte[] execSELECT_FID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 2, 12, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void execMSE(CardChannel cardChannel, int n, int n2, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, n, n2, byArray, 256));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:SET failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, byArray, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO: COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }
}

