/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.LogCardChannel;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.T0CardChannel;
import at.gv.egiz.smcc.reader.CardReader;
import at.gv.egiz.smcc.reader.ReaderFactory;
import java.util.Locale;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureCard
implements SignatureCard {
    private final Logger log = LoggerFactory.getLogger(AbstractSignatureCard.class);
    protected Locale locale = Locale.getDefault();
    private Card card_;
    private String cardterminalname;
    protected CardReader reader;
    int testMember = 3;

    protected AbstractSignatureCard() {
    }

    protected String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && byArray.length > 0) {
            stringBuffer.append(Integer.toHexString((byArray[0] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[0] & 0xF));
        }
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(Integer.toHexString((byArray[i] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        this.card_ = card;
        this.reader = ReaderFactory.getReader(card, cardTerminal);
        this.cardterminalname = cardTerminal.getName();
    }

    @Override
    public Card getCard() {
        return this.card_;
    }

    @Override
    public String getTerminalName() {
        return this.cardterminalname;
    }

    protected CardChannel getCardChannel() {
        if (this.card_.getProtocol().equalsIgnoreCase("T=0")) {
            return new T0CardChannel(this.card_.getBasicChannel());
        }
        return new LogCardChannel(this.card_.getBasicChannel());
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be set to null");
        }
        this.locale = locale;
    }

    @Override
    public void disconnect(boolean bl) {
        this.log.debug("Disconnect called");
        if (this.card_ != null) {
            try {
                this.card_.disconnect(bl);
            }
            catch (Exception exception) {
                this.log.info("Error while resetting card", exception);
            }
        }
    }

    @Override
    public void reset() throws SignatureCardException {
        try {
            this.log.debug("Disconnect and reset smart card.");
            this.card_.disconnect(true);
            this.log.debug("Reconnect smart card.");
            this.card_ = this.reader.connect();
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Failed to reset card.", cardException);
        }
    }

    public void interfaceMethod(PinInfoTest pinInfoTest) {
    }

    public static class PinInfoTest {
        void setStatus(int n) {
        }
    }
}

