/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.util.TLV;
import iaik.me.asn1.ASN1;
import java.io.IOException;
import java.util.Arrays;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public abstract class AbstractISCard
extends AbstractSignatureCard
implements SignatureCard {
    protected static final byte[] OID = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};

    protected abstract byte[] getAppletID();

    protected void selectApplet(CardChannel cardChannel) throws CardException, SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 4, 0, this.getAppletID());
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("Error selecting card applet. Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected int toInt(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n3 = byArray[i];
            n3 = n3 < 0 ? n3 + 256 : n3;
            n2 += (int)((double)n3 * Math.pow(256.0, n - i - 1));
        }
        return n2;
    }

    protected byte[] retrieveSigningCertificate(byte[] byArray, byte[] byArray2, String string) throws SignatureCardException, IOException {
        byte[] byArray3 = null;
        ASN1 aSN1 = new ASN1(byArray2);
        int n = aSN1.getEncoded().length;
        byte[] byArray4 = new byte[byArray2.length - n];
        System.arraycopy(byArray2, n, byArray4, 0, byArray4.length);
        ASN1 aSN12 = new ASN1(byArray4);
        if (aSN1.getElementAt(0).getElementAt(0).gvString().contains(string)) {
            byArray3 = this.retrieveCertFromFile(byArray, aSN1);
        } else if (aSN12.getElementAt(0).getElementAt(0).gvString().contains(string)) {
            byArray3 = this.retrieveCertFromFile(byArray, aSN12);
        } else {
            throw new SignatureCardException("Cannot find certificate meta information.");
        }
        return byArray3;
    }

    protected byte[] retrieveCertFromFile(byte[] byArray, ASN1 aSN1) throws SignatureCardException {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = aSN1.getElementAt(aSN1.getSize() - 1).getEncoded();
            if ((byArray3[0] & 0xFF) != 161) {
                throw new SignatureCardException("Cannot retrieve enduser certificate.");
            }
            int n = (byArray3[1] & 0xF0) == 128 ? (byArray3[1] & 0xF) + 2 : 2;
            ASN1 aSN12 = new ASN1(Arrays.copyOfRange(byArray3, n, byArray3.length));
            int n2 = aSN12.getElementAt(0).getElementAt(1).gvInt();
            byte[] byArray4 = aSN12.getElementAt(0).getElementAt(2).getEncoded();
            int n3 = this.toInt(new TLV(byArray4, 0).getValue());
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Cannot retrieve enduser certificate.", iOException);
        }
        return byArray2;
    }
}

